/*
 * SOES Simple Open EtherCAT Slave
 *
 * File    : cpuinit.c
 * Version : 0.9.2
 * Date    : 22-02-2010
 * Copyright (C) 2007-2010 Arthur Ketels
 *
 * SOES is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * SOES is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * As a special exception, if other files instantiate templates or use macros
 * or inline functions from this file, or you compile this file and link it
 * with other works to produce a work based on this file, this file does not
 * by itself cause the resulting work to be covered by the GNU General Public
 * License. However the source code for this file must still be made available
 * in accordance with section (3) of the GNU General Public License.
 *
 * This exception does not invalidate any other reasons why a work based on
 * this file might be covered by the GNU General Public License.
 *
 * The EtherCAT Technology, the trade name and logo "EtherCAT" are the intellectual
 * property of, and protected by Beckhoff Automation GmbH.
 */
//#include <avr/io.h>
#include "cpuinit.h"
#include "mbed.h"

extern float FrontRight_offset;
extern float FrontLeft_offset;
extern float BackLeft_offset;
extern float BackRight_offset;

void cpuinit(void)
{
    //shoe_serial.baud(921600);
    //et1100_spi.format(8,3);
    et1100_spi.frequency(1000000);
    //inintialize all dummy inputs
    DigitalOut dummy1(PTC2);//do not leave ADC input floating
    DigitalOut dummy2(PTC0);
    DigitalOut dummy3(PTC1);
    //DigitalOut dummy4(PTD1);
    DigitalOut dummy5(PTD5);
    DigitalOut dummy6(PTD6);
    DigitalOut dummy7(PTE20);
    DigitalOut dummy8(PTE21);
    DigitalOut dummy9(PTE22);
    DigitalOut dummy10(PTE23);
    DigitalOut dummy11(PTE29);
    DigitalOut dummy12(PTE30);
    dummy1 = dummy2 = dummy3 = dummy5 = dummy6 = 0;
    dummy7 = dummy8 = dummy9 = dummy10 = dummy11 = dummy12 = 0;
    //offset correction
    wait_ms(20);
    FrontLeft_offset = adcFrontLeft;
    FrontRight_offset = adcFrontRight;
    BackLeft_offset = adcBackLeft;
    BackRight_offset = adcBackRight;

}

