#ifndef XBUS_H_
#define XBUS_H_ 1

#include "MODSERIAL.h"
#define XBUS_BUFFER_LENGTH 255

enum XBUS_STATE {XBUS_IDLE = 0, XBUS_BID, XBUS_MID, XBUS_LEN, XBUS_DATA, XBUS_CS};

struct xbus_uart
{
    uint16_t    counter;
    uint8_t     checksum;
    volatile uint8_t   checksum_ok;
    volatile uint8_t   message_complete;
    uint8_t     quelength;
    uint8_t     buffer[XBUS_BUFFER_LENGTH];
    enum XBUS_STATE state;
};


typedef struct xbus_struct
{
    //USART_t * uart;
	struct xbus_uart rx;
    //volatile struct xbus_uart tx;
} xbus_t;



// Create checksum, pointer to array (starting w. 0xFA), length of complete array
uint8_t XbusCreateChecksum(uint8_t *, uint8_t);
void XbusSetupReceiver(xbus_t * xbus);
void XbusReceiveState(xbus_t * xbus, uint8_t rxdata);
void XbusInitializeXbusMaster(void);
void XbusCreateMessage(uint8_t bid, uint8_t mid, uint8_t message_size, uint8_t *message, uint8_t *buffer );
void XbusSetBaudRate(uint8_t baud);
void XbusReset(void);
void XbusGoToConfig(void);
#endif

