/*
 * SOES Simple Open EtherCAT Slave
 *
 * File    : cpuinit.c
 * Version : 0.9.2
 * Date    : 22-02-2010
 * Copyright (C) 2007-2010 Arthur Ketels
 *
 * SOES is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2 as published by the Free
 * Software Foundation.
 *
 * SOES is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * As a special exception, if other files instantiate templates or use macros
 * or inline functions from this file, or you compile this file and link it
 * with other works to produce a work based on this file, this file does not
 * by itself cause the resulting work to be covered by the GNU General Public
 * License. However the source code for this file must still be made available
 * in accordance with section (3) of the GNU General Public License.
 *
 * This exception does not invalidate any other reasons why a work based on
 * this file might be covered by the GNU General Public License.
 *
 * The EtherCAT Technology, the trade name and logo "EtherCAT" are the intellectual
 * property of, and protected by Beckhoff Automation GmbH.
 */
//#include <avr/io.h>
#include "cpuinit.h"
#include "mbed.h"

extern xbus_t xbus_master;
extern MODSERIAL xbus_serial;

void cpuinit(void)
{
    //shoe_serial.baud(921600);
    //et1100_spi.format(8,3);
    et1100_spi.frequency(1000000);
    
    xbus_serial.baud(230400);
    wait(1);//because Xbus master and IMU's need to boot.
    XbusSetupReceiver(&xbus_master); //initialize struct
    XbusInitializeXbusMaster();
    
    wait_ms(20);


}

