#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"

//Define objects
AnalogIn    emg0(PTB1); //Analog input
PwmOut      red(LED_RED); //PWM output
Ticker log_timer;
MODSERIAL pc(USBTX,USBRX);
HIDScope scope(2);

/** Looper function
* functions used for Ticker and Timeout should be of type void <name>(void)
* i.e. no input arguments, no output arguments.
* if you want to change a variable that you use in other places (for example in main)
* you will have to make that variable global in order to be able to reach it both from
* the function called at interrupt time, and in the main function.
* To make a variable global, define it under the includes.
* variables that are changed in the interrupt routine (written to) should be made
* 'volatile' to let the compiler know that those values may change outside the current context.
* i.e.: "volatile uint16_t emg_value;" instead of "uint16_t emg_value"
* in the example below, the variable is not re-used in the main function, and is thus declared
* local in the looper function only.
**/
void looper()
{
    /*variable to store value in*/    
    uint16_t emg_value;
    /*put raw emg value both in red and in emg_value*/
    red.write(emg0.read());      // read float value (0..1 = 0..3.3V)
    emg_value = emg0.read_u16(); // read direct ADC result (0..4096 = 0..3.3V)
    /*send value to PC. Line below is used to prevent buffer overrun */
    if(pc.rxBufferGetSize(0)-pc.rxBufferGetCount() > 30)
        pc.printf("%u\n",emg_value);
    scope.set(0,emg_value);
    scope.set(1,red.read());
    scope.send();
    /**When not using the LED, the above could also have been done this way:
    * pc.printf("%u\n", emg0.read_u16());
    */
}

int main()
{
    /*setup baudrate. Choose the same in your program on PC side*/
    pc.baud(115200);
    /*set the period for the PWM to the red LED*/
    red.period_ms(2);
    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.01 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    log_timer.attach(looper, 0.005);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}