#include "mbed.h"

// myled is an object of class DigitalOut. It uses the LED_RED pin
// in human speech: myled is an output that can be set to zero or one. LED_RED is the pin which is connected to the output
DigitalOut myled(LED_RED);

// pot is an object of class AnalogIn. It uses the PTB0 pin
// in human speech: pot is an analog input. You can read the voltage on pin PTB0
AnalogIn pot(PTB0);

int main() {
    //declare a variable to store the potmeter value in. myled.read() returns a float.
    float tijd;
    //while 1 is unequal to zero. For humans: loop forever
    while(1) {
        //read value of potmeter, and store in variable
        tijd = pot.read();
        //make pin myled 'high', which means 3.3V. This turns off the LED
        myled = 1;
        //Wait takes seconds as argument ( wait(2.5) waits for 2 seconds)
        //in this case, we're waiting 0.5 seconds if the potmeter is in one end position (analog in has value 1.00)
        // and we're waiting zero seconds if the potmeter is in the other end position (analog in has value 0.00)
        wait(0.5*tijd);
        //make pin myled 'low', which means 0V. This turns on the LED
        myled = 0;
        //wait depending on 'tijd', inverse operation of other wait statement, so total time will always be 0.5
        wait(0.5*(1-tijd));
    }
}
