#include "mbed.h"

// myled is an object of class PwmOut. It uses the LED_RED pin
// in human speech: myled is an output that can be controlled with PWM. LED_RED is the pin which is connected to the output
PwmOut myled(LED_RED);

// pot is an object of class AnalogIn. It uses the PTB0 pin
// in human speech: pot is an analog input. You can read the voltage on pin PTB0
AnalogIn pot(PTB0);


//start 'main' function. Should be done once in every C(++) program
int main()
{
    //setup some stuff
    //period of PWM signal is 10kHz. Every 100 microsecond a new PWM period is started
    myled.period_ms(0.1);
    //while 1 is unequal to zero. For humans: loop forever
    while(1) {
        //Complicated stuff: 
        //   pot.read() read the value of pot; this gives a value between 0 and 1 depending on the voltage on pin PTB0
        //   this value is then put in myled.write()
        //      myled.write(x) -> write value x (between 0 and 1) to PwmOut myled. The duty cycle goes from 0% to 100%.
        //Warning: Because the LED is full on when the output is completely low (0% duty cycle), the led is full on when the potmeter value is zero.
        
        //The code below could also be written as:
        //myled = pot; 
        myled.write(pot.read());
        //wait some time to give the LED output a few PWM cycles. Otherwise a new value is written before the previously set PWM period (of 100microseconds) is finished
        //This loop executes at roughly 100Hz (1/0.01s)
        wait(0.01);
    }
}

