#include "mbed.h"

// redled is an object of class PwmOut. It uses the LED_RED pin
// in human speech: redled is an output that can be controlled with PWM. LED_RED is the pin which is connected to the output
PwmOut redled(LED_RED);

//ditto...
PwmOut greenled(LED_GREEN);
PwmOut blueled(LED_BLUE);

// pot is an object of class AnalogIn. It uses the PTB0 pin
// in human speech: pot is an analog input. You can read the voltage on pin PTB0
AnalogIn pot(PTB0);


//start 'main' function. Should be done once in every C(++) program
int main()
{
    float potvalue;
    //setup some stuff
    //period of PWM signal is 10kHz. Every 100 microsecond a new PWM period is started
    redled.period_ms(0.1);
    greenled.period_ms(0.1);
    blueled.period_ms(0.1);
    //while 1 is unequal to zero. For humans: loop forever
    while(1)
    {
        //limit loop time
        wait(0.01);
        //read potentiometer, store in potvalue
        potvalue = pot.read();
        if(potvalue < 0.33)
        {
            redled = 1-potvalue; //subtract from 1 to get high value (almost off) at potmeter maximum
            greenled = 1; //off
            blueled  = 1; //off
        }
        else // value greater or equal to 0.33
        {
            if(potvalue < 0.66)
            {
                redled = 1-potvalue;
                greenled = 1-potvalue;
                blueled = 1;
            }
            else //value greater or equal to 0.66
            {
                redled = 1-potvalue;
                greenled = 1-potvalue;
                blueled = 1-potvalue;
            }
        }
    }
}

