#include "mbed.h"
#include "encoder.h"
/** Use MODSERIAL to have non-blocking serial communication
* Not absolutely needed in this example, but it's a good habbit
*/
#include "MODSERIAL.h"


int main() {
    /** Make encoder object.
    * First pin should be on PTAx or PTDx because those pins can be used as InterruptIn
    * Second pin can be any digital input
    */
    Encoder motor1(PTD0,PTC9);
    /*Use USB serial to send values*/
    MODSERIAL pc(USBTX,USBRX);
    /*Set baud rate to 115200*/
    pc.baud(115200);
    while(1) { //Loop
        /**Wait to prevent buffer overflow, and to keep terminal readable (not scrolling too fast)*/
        wait(0.2);
        /** print position (integer) and speed (float) to the PC*/
        pc.printf("pos: %d, speed %f \r\n",motor1.getPosition(), motor1.getSpeed());
    }
}