#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"

/*******************************************************************************
*                                                                              *
*   Code can be found at http://mbed.org/users/vsluiter/code/BMT-K9-Regelaar/  *
*                                                                              *
********************************************************************************/

/** keep_in_range -> float in, and keep_in_range if less than min, or larger than max **/
void keep_in_range(float * in, float min, float max);

/** variable to show when a new loop can be started*/
/** volatile means that it can be changed in an    */
/** interrupt routine, and that that change is vis-*/
/** ible in the main loop. */

volatile bool looptimerflag;

/** function called by Ticker "looptimer"     */
/** variable 'looptimerflag' is set to 'true' */
/** each time the looptimer expires.          */
void setlooptimerflag(void)
{
    looptimerflag = true;
}


int main() {
    //LOCAL VARIABLES 
    /*Potmeter input*/
    AnalogIn potmeter(PTC2);
    /* Encoder, using my encoder library */
    /* First pin should be PTDx or PTAx  */
    /* because those pins can be used as */
    /* InterruptIn                       */
    Encoder motor1(PTD0,PTC9);
    /* MODSERIAL to get non-blocking Serial*/
    MODSERIAL pc(USBTX,USBRX);
    /* PWM control to motor */
    PwmOut pwm_motor(PTA12);
    /* Direction pin */
    DigitalOut motordir(PTD3);
    /* variable to store setpoint in */
    float setpoint;
    /* variable to store pwm value in*/
    float pwm_to_motor;
    //START OF CODE
    
    /*Set the baudrate (use this number in RealTerm too! */
    pc.baud(230400);
    
   /*Create a ticker, and let it call the     */
   /*function 'setlooptimerflag' every 0.01s  */
    Ticker looptimer;
    looptimer.attach(setlooptimerflag,0.01);  
    /* Oops... I left some test code in my program */
    pc.printf("bla");
    
    //INFINITE LOOP 
    while(1) {
        /* Wait until looptimer flag is true. */
        /* '!=' means not-is-equal            */
        while(looptimerflag != true);
        /* Clear the looptimerflag, otherwise */
        /* the program would simply continue  */
        /* without waitingin the next iteration*/
        looptimerflag = false;
        
        /* Read potmeter value, apply some math */
        /* to get useful setpoint value         */
        setpoint = (potmeter.read()-0.5)*2000;
        
        /* Print setpoint and current position to serial terminal*/
        pc.printf("s: %f, %d \n\r", setpoint, motor1.getPosition());
        
        /* This is a P-action! calculate error, multiply with gain, and store in pwm_to_motor */
        pwm_to_motor = (setpoint - motor1.getPosition())*.001;
        /* Coerce pwm value if outside range          */
        /* Not strictly needed here, but useful       */
        /* if doing other calculations with pwm value */
        keep_in_range(&pwm_to_motor, -1,1);
        
        /* Control the motor direction pin. based on   */
        /* the sign of your pwm value.      If your    */
        /* motor keeps spinning when running this code */
        /* you probably need to swap the motor wires,  */
        /* or swap the 'write(1)' and 'write(0)' below */
        if(pwm_to_motor > 0)
            motordir.write(1);
        else
            motordir.write(0);
        //WRITE VALUE TO MOTOR
        /* Take the absolute value of the PWM to send */
        /* to the motor. */  
        pwm_motor.write(abs(pwm_to_motor));
    }
}


//coerces value 'in' to min or max when exceeding those values
//if you'd like to understand the statement below take a google for
//'ternary operators'.
void keep_in_range(float * in, float min, float max)
{
    *in > min ? *in < max? : *in = max: *in = min;
}



