#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "USBMouse.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)


int main(void) {
    USBMouse mouse;
    float pct_tsi = 0;
    TSISensor tsi;
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
    rled.period_ms(2);
    bled.period_ms(2);
    gled.period_ms(2);
    while (true) {
        float accs[3];
        float pct_tsi_t;
        pct_tsi_t = tsi.readPercentage();
        pct_tsi = pct_tsi_t == 0 && pct_tsi > 0.1 ? pct_tsi : pct_tsi_t;
        acc.getAccAllAxis(accs);
        rled = 1.0 - (abs(accs[0])*pct_tsi);
        gled = 1.0 - (abs(accs[1])*pct_tsi);
        bled = 1.0 - (abs(accs[2])*pct_tsi);
        mouse.move(accs[0]*10,accs[1]*-10);
        wait(0.001);
    }
}
