#include "GameButton.h"

GameButton::GameButton(PinName pin, float time=0.5)
{
    pushflag = false;
    intpin = new InterruptIn(pin);
    (*intpin).mode(PullUp);
    (*intpin).fall(this, &GameButton::PushHandler);
    m_time = time;
    m_timeoutactive = false;
    inpin = pin;
    //timeout = new Timeout(m_time);
}

void GameButton::PushHandler(void)
{
    DigitalIn input(inpin);
    wait_ms(5);
    if(!input)
    {
        pushflag = true;
        m_timeoutactive = true;
        timeout.attach(this, &GameButton::TimeOutHandler, m_time);
        pushhandlercallback();
    }
}

void GameButton::TimeOutHandler(void)
{
    m_timeoutactive = false;
}

bool GameButton::getTimeoutActive(void)
{
    return m_timeoutactive;
}