#include "paddle.h"

Paddle::Paddle()
{
    setColor(255,255,255);
    setSize(4);
    position = -getSize();
    direction = 1;
    setSpeed(50);
}

void Paddle::setSpeed(float speed)
{
//truncate
    float time;
    if(speed > 100000)
        speed = 100000;
    if(speed <= 0)
        speed = 0.001;
    m_speed = speed;
    time = 1/m_speed;
    UpdatePosition.detach();
    UpdatePosition.attach(this,&Paddle::PositionUpdater, time);
}

void Paddle::PositionUpdater(void)
{
    if(direction == 1)
        position++;
    else
        position--;
}

uint8_t Paddle::getColor(uint8_t pixel, uint8_t color)
{
    if(pixel<MAX_PADDLE_SIZE && color < 3)
        return m_paddle[pixel][color];
    else
        return 0;
}

uint8_t Paddle::getSize(void)
{
    return m_size;
}

void Paddle::setSize(uint8_t size)
{
    if(size > MAX_PADDLE_SIZE)
        size = MAX_PADDLE_SIZE;
    m_size = size;
    setColor(m_red, m_green, m_blue);
}

void Paddle::setColor(uint8_t red, uint8_t green, uint8_t blue)
{
    uint8_t paddlepixel;
    m_red = red;
    m_green = green;
    m_blue = blue;
    for(paddlepixel = 0 ; paddlepixel < MAX_PADDLE_SIZE ; paddlepixel++)
    {
        float factor;
        factor = 1.0*paddlepixel/(m_size*1.0);
        if (factor > 1)
            factor = 1;
        factor = factor*factor*factor;// make the effect more dramatic
        m_paddle[paddlepixel][0] = (float)m_red * factor; 
        m_paddle[paddlepixel][1] = (float)m_green * factor;
        m_paddle[paddlepixel][2] = (float)m_blue * factor;
    }
}
