/*************************************************************
  Blynk is a platform with iOS and Android apps to control
  Arduino, Raspberry Pi and the likes over the Internet.
  You can easily build graphic interfaces for all your
  projects by simply dragging and dropping widgets.

    Downloads, docs, tutorials: http://www.blynk.cc
    Sketch generator:           http://examples.blynk.cc
    Blynk community:            http://community.blynk.cc
    Follow us:                  http://www.fb.com/blynkapp
                                http://twitter.com/blynk_app

  Blynk library is licensed under MIT license
  This example code is in public domain.

 *************************************************************
  This example shows how to use Serial/USB
  to connect your project to Blynk.

 *************************************************************/
#include "mbed.h"

// Define your serial for console logs:
Serial pc(p9, p10);

// Define your serial for data:
Serial serial(USBTX, USBRX);

//#define BLYNK_DEBUG
#define BLYNK_PRINT pc
#include <Blynk/BlynkSimpleSerial.h>

// You should get Auth Token in the Blynk App.
// Go to the Project Settings (nut icon).
char auth[] = "YourAuthToken";

DigitalOut led(LED1);

BLYNK_WRITE(V1) {
  led = !led;
  Blynk.virtualWrite(V2, BlynkMillis()/1000);
}

void setup()
{
  pc.baud(115200);

  serial.baud(115200);

  Blynk.begin(serial, auth);
}

void loop()
{
  Blynk.run();
}

int main() {
  setup();
  while(1) {
    loop();
  }
}
