/*************************************************************
  Blynk is a platform with iOS and Android apps to control
  Arduino, Raspberry Pi and the likes over the Internet.
  You can easily build graphic interfaces for all your
  projects by simply dragging and dropping widgets.

    Downloads, docs, tutorials: http://www.blynk.cc
    Sketch generator:           http://examples.blynk.cc
    Blynk community:            http://community.blynk.cc
    Follow us:                  http://www.fb.com/blynkapp
                                http://twitter.com/blynk_app

  Blynk library is licensed under MIT license
  This example code is in public domain.

 *************************************************************
  NOTE: Please set this config in your MicroBitConfig.h:
    #define MICROBIT_BLE_ENABLED       1
    #define MICROBIT_BLE_PAIRING_MODE  0
    #define MICROBIT_BLE_OPEN          1

  Optionally, you can disable unused services:
    #define MICROBIT_BLE_DFU_SERVICE   0
    #define MICROBIT_BLE_EVENT_SERVICE 0

  Warning: Bluetooth support is in beta!

 *************************************************************/
#include <MicroBit.h>
MicroBit uBit;

//#define BLYNK_DEBUG
#define BLYNK_PRINT uBit.serial

#include <BlynkSimpleMicroBit.h>

// You should get Auth Token in the Blynk App.
// Go to the Project Settings (nut icon).
char auth[] = "YourAuthToken";


void onConnected(MicroBitEvent e)
{
  uBit.display.printChar('+', 500);
  Blynk.startSession();
}

void onDisconnected(MicroBitEvent e)
{
  uBit.display.print("- - -", 100);
  Blynk.disconnect();
}

int counter = 0;

void onPressed(MicroBitEvent e)
{
  char buf[8];
  sprintf(buf, "%d", counter);

  Blynk.virtualWrite(V1, buf);
  uBit.serial.printf("%s\n", buf);
  uBit.display.scroll(buf);
  
  counter++;
}

void setup() {
  // Initialise the micro:bit runtime.
  uBit.init();
  uBit.display.scrollAsync("BLYNK", 100);
  
  // listen for Bluetooth connection state changes
  uBit.messageBus.listen(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_CONNECTED, onConnected);
  uBit.messageBus.listen(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_DISCONNECTED, onDisconnected);
  
  // 
  uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onPressed);

  // Add Blynk service
  Blynk.begin(*uBit.ble, auth);
}

void loop() {
  Blynk.run();
}

int main(void) {
    setup();
    while(1) {
        loop();
        uBit.sleep(10);
    }
}
