#include "mbed.h"

#define MAX_DELAY   15000
#define MIN_DELAY   50

#define MAX_GAIN    25
#define MIN_GAIN    2

/* ADC for the microphone/input, DAC for the speaker/output */
AnalogIn mic(p19);
AnalogOut speaker(p18);
/* Two potentiometer voltage dividers for the delay/gain control knobs */
AnalogIn delay_knob(p15);
AnalogIn gain_knob(p16);

unsigned short buffer[MAX_DELAY];

/* inv_gain = 1 / gain; it's faster to avoid floating point during the main loop */
int inv_gain = 3;
int delay = MAX_DELAY;

void read_knobs(void) {
    delay = delay_knob*MAX_DELAY;
    //gain = gain_knob*MAX_GAIN;
    if (delay < MIN_DELAY)
        delay = MIN_DELAY;
    /*if (gain < MIN_GAIN)
        gain = MIN_GAIN;
    if (gain == MAX_GAIN)
        gain -= 1;*/
}

int main() {
    int i;
    /* Fill up the sample buffer first */
    for (i = 0; i < delay; i++)
        buffer[i] += mic.read_u16();

    for (i = 0; ; ) {
        /* Multiply old data by the gain, add new data */
        buffer[i] = buffer[i]/inv_gain + mic.read_u16();
        /* Write to speaker */
        speaker.write_u16(buffer[i]);
        /* Increment index and wrap around, effectively only using "delay" length of the buffer */
        i = (i+1) % delay;
        /* Occasionally read the knobs */
        if (i == 0)
            read_knobs();
    }
}