/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include <stdint.h>

AnalogIn sensor(A1);
PwmOut buzzer(D3);
Serial pc(USBTX, USBRX);

int main() {
    float input;
    while(1) {
        input = sensor.read();
        input = input * 100;
        
        if(input <= 40) {
            buzzer.write(0.0);
        } else {
            while(input > 40) {
                buzzer.write(0.6);
                buzzer.period(1.0 / 333);
                wait(2);
                buzzer.period(1.0 / 444);
                wait(2);
                input = 100 * (sensor.read());
                pc.printf("\nSoil Moisture Content Value, S = %f (Bad)\n", input);
            }
        }
        wait(4);
        pc.printf("\nSoil Moisture Content Value, S = %f (Good)\n", input);    
    }
}
