#include "mbed.h"
#include "string.h"
#include "TextLCD.h"
#include "TextLCDScroll.h"

TextLCDScroll lcd(D13, D12, D11, D10, D9, D8, TextLCD::LCD16x2);
AnalogIn entry(A1);
AnalogIn exi(A2);


void Display(int per) {
    char buf[20];
    sprintf(buf, "%d", per);
    lcd.setLine(0, "Persons inside: ");
    lcd.setLine(1, buf);
    //wait(1);
}


int main() {
    float en, ex;
    int count = 0;
    
    while(1) {
        en = entry * 1000;
        ex = exi * 1000;
        
        if(en <= 400) {
            count = count + 1;
            Display(count);
            wait(0.5);
        }
        else if(ex <= 400) {
            if(count == 0) {
                Display(count);
                wait(0.5);
            }
            else {
                count = count - 1;
                Display(count);
                wait(0.5);
            }
        }
        else if((en <= 400) && (ex <= 400)) {
            Display(count);
            wait(0.5);
        }
        else {
            Display(count);
            wait(0.5);
        }
    }    
}