#include "OAuth4Tw.h"
#include "mbed.h"
#include "oauth.h"

OAuth4Tw::OAuth4Tw(const char *c_key, const char *c_secret,
        const char *t_key, const char *t_secret)
        :consumer_key(c_key),
     consumer_secret(c_secret),
     token_key(t_key),
     token_secret(t_secret) { }

std::string OAuth4Tw::url_escape(const char *str) {
    return oauth_url_escape(str);
}

std::string OAuth4Tw::post(const char *uri, std::string postarg) {

    std::string req_url;
    std::string postres;
    
    req_url = oauth_sign_url2(uri, &postarg, OA_HMAC, 0,
            consumer_key, consumer_secret, token_key, token_secret);
    printf("req_url2:%s\n", req_url.c_str());

    postres = oauth_http_post(req_url.c_str(), postarg.c_str());
    return postres;
}

