#ifndef _RADIO_CONFIG_H_
#define _RADIO_CONFIG_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <vector>
#include "stdint.h"
#include "jsmn.h"

#define RADIO_NAME_LEN 100
struct RadioSlave
{
    uint64_t radioID;
    char name[RADIO_NAME_LEN];
    
    uint16_t temp_pin;
    uint16_t humid_pin;
    uint16_t lumin_pin;
    uint16_t sprinkler_pin;    
    uint16_t hthreshold;
    
    RadioSlave()
        :radioID(0),
        temp_pin(0),
        humid_pin(0),
        lumin_pin(0),
        sprinkler_pin(0),
        hthreshold(0)
    {
        memset(&name[0], 0, RADIO_NAME_LEN);
    }   
    void debug()
    {
        printf("Slave ID : %lld\r\n", radioID);
        printf("Name : \"%s\"\r\n", &name[0]);
        printf("Temperature Pin: %d\r\n", temp_pin);
        printf("Humidity Pin: %d\r\n", humid_pin);
        printf("Luminance Pin: %d\r\n", lumin_pin);
        printf("Sprinkler Pin: %d\r\n", sprinkler_pin);
        printf("Humidity Threshold: %d\r\n", hthreshold);
    }
};

struct RadioCfg
{
    uint64_t    radioID;
    char name[RADIO_NAME_LEN];
    char country[RADIO_NAME_LEN];
    uint32_t utc_offset;    
    std::vector<RadioSlave> radios;
    
    RadioCfg()
        :radioID(0),
        utc_offset(0)
    {
        memset(&name[0], 0, RADIO_NAME_LEN);
        memset(&country[0], 0, RADIO_NAME_LEN);
        radios.clear();
    }
       
    inline void debug()
    {
        printf("Radio ID: %lld\r\n", radioID);
        printf("Name : \"%s\"\r\n", &name[0]);
        printf("Country : \"%s\"\r\n", &country[0]);
        printf("UTC Offset: %d\r\n", utc_offset);        
        std::vector<RadioSlave>::iterator it;
        for(it = radios.begin(); it != radios.end(); it++)
        {
            (*it).debug();
        }
    }
    
};

int parseradioconfig(const char * jsonstring, RadioCfg &);

#endif
