/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: main.cpp
Entrada principal y asignación del pin out.
************************************/

#include "mbed.h"
#include "ecocore.h"
#include "ecocom.h"
#include "ecocommand.h"

ecocore nucleo;	//Control de hardware.
ecocom vt200;		//Control de comunicaciones.
ecocommand comando;	//Interprete de comandos.

DigitalOut LedRx(LED1); //Para indicaciones.
DigitalOut LedEvento(LED2);
DigitalOut LedTx(LED3);


int main(){
	LedRx=0;
	LedEvento=0;
	LedTx=0;
	while (1){ //Bucle principal.
		//Si Rx recibir e interpretar los datos.
		if (vt200.RxCompleta){
			LedRx=1;
			vt200.TxDatos(comando.InterpretarComando(vt200.RxCad,nucleo.entrada,nucleo.salida));
			vt200.RxCompleta=false;
			LedRx=0;
		}
		//Si hay evento transmitirlo.
		if (nucleo.Evento()){ //Forzamos el envio del estado de las entradas.
			LedEvento=1;
			vt200.TxDatos(comando.InterpretarComando("$VM+IN?",nucleo.entrada,nucleo.salida));
			nucleo.ReiniciarCuenta(); //Reiniciamos la cuenta por cada evento.
			LedEvento=0;
		}
		//Si expira el tiempo de letargo, transmitir estado general.
		if (nucleo.ExpiradoTiempoTx()){ //Forzamos un informe global.
			LedTx=1;
			vt200.TxDatos(comando.InterpretarComando("$VM+?",nucleo.entrada,nucleo.salida));
			LedTx=0;
		}
	}
}
