/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecotron_es.h
Definicion de las entradas y salidas
para el ecotron.
************************************/

#include "mbed.h"

#ifndef _ECOTRON_ES
#define _ECOTRON_ES

#define DIGITAL true        //Sobrecarga de definicion para los tipos de E/S.
#define ANALOGICA false
#define E_NOEXIST    -1    //Error en identificacion: entrada o salida inexistente.
#define E_NOTIPO -2 //Error de tipo, se esperaba digital y es analogica o viceversa.
#define ID_DIGITAL_OFF 0    //Identificadores para las entradas y su estado.
#define ID_DIGITAL_ON 1
#define ID_DIGITAL 2
#define ID_ANALOGICA 3
#define MAX_ENTRADAS 12     //Maximo numero de entradas del Ecotron.
#define MAX_SALIDAS 4    //Maximo numero de salidas del Ecotron.
#define ENTRADAS_CONFIGURABLES 5 //Numero de entradas configurables como analogicas o digitales.
#define SALIDAS_CONFIGURABLES 4 //Numero de salidas configurables como analogicas o digitales.

class entradas {

private:
    bool EntradasConfigurables[ENTRADAS_CONFIGURABLES];

public:
    entradas();    
    entradas(bool e[]);
    int TipoEntrada(int e);
    int VerEntradaDigital(int e);
    float VerEntradaAnalogica(int e);
    
}; //Final de las entradas.

class salidas {

private:
    bool SalidasConfigurables[SALIDAS_CONFIGURABLES];    
    void InicializaSalidas();
    void InicializaSalidas(bool s[]);

public:
    salidas();
    salidas(bool s[]);
    int TipoSalida(int s);
    int VerSalidaDigital(int s); //Devuelve el estado de la salida digital s.
    int VerSalidaAnalogica(int s); //Devuelve el estado de la salida analogica s.
    bool PonSalidaDigital(int s,bool b);
    bool PonSalidaAnalogica(int s,float v);

}; //Final de las salidas.

#endif

