/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecotron_es.cpp
************************************/

#include "ecotron_es.h"

DigitalIn di1(p8);      //Entradas digitales.
DigitalIn di2(p9);
DigitalIn di3(p10);
DigitalIn di4(p11);
DigitalIn di5(p12);
DigitalIn di6(p13);
DigitalIn di7(p14);
DigitalIn di8(p15);
DigitalIn di9(p16);
DigitalIn di10(p17);
DigitalIn di11(p18);
DigitalIn di12(p19);

AnalogIn ai1(p15);        //La entrada analogica 1 se solapa con la digital 8...
AnalogIn ai2(p16);        //...y asi sucesivamente, actuando segun se le mande...
AnalogIn ai3(p17);        //...en el programa principal.
AnalogIn ai4(p18);
AnalogIn ai5(p19);


DigitalOut do1(p21);    //Salidas digitales.
DigitalOut do2(p22);
DigitalOut do3(p23);
DigitalOut do4(p24);
DigitalOut do5(p25);
DigitalOut do6(p26);

PwmOut ao1(p21);    //Salidas analogicas por PWM.
PwmOut ao2(p22);
PwmOut ao3(p23);
PwmOut ao4(p24);
PwmOut ao5(p25);
PwmOut ao6(p26);

//----------------------------------------------
// ENTRADAS:
//----------------------------------------------
/**
    El contructor por defecto hace que todas las
    entradas configurables sean digitales.
**/
entradas::entradas() {

    int i;
    for (i=0; i<ENTRADAS_CONFIGURABLES; ++i)
        EntradasConfigurables[i]=DIGITAL;
}

/**
    Constructor con una matriz de boolean
    de tamanyo ENTRADAS_CONFIGURABLES, en
    la cual se especifica el tipo de entrada
    analogica o digital en su posicion adecuada.
**/
entradas::entradas(bool e[]){

    int i;
    for (i=0; i<ENTRADAS_CONFIGURABLES; ++i)
        EntradasConfigurables[i]=e[i];
}

/**
    Devuelve verdadero si la entrada e es digital,
    y falso en caso contrario.
**/
int entradas::TipoEntrada(int e){

    int NumDigitales=(MAX_ENTRADAS-ENTRADAS_CONFIGURABLES)+1;
    if ((e<=0)||(e>MAX_ENTRADAS))
        return E_NOEXIST;
    if ((e>0)&&(e<NumDigitales)) //Entradas 1..7 son digitales.
        return ID_DIGITAL;
    if (EntradasConfigurables[e-NumDigitales]==DIGITAL)
        return ID_DIGITAL;
    else
        return ID_ANALOGICA;    
}

/**
    Devuelve el estado de la entrada e.
    Si no existe devuelve E_NOEXIST.
    Si es analogica, devuelve E_NOTIPO.
**/
int entradas::VerEntradaDigital(int e){

    switch(e){
        case 1:
            if (di1)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 2:
            if (di2)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 3:
            if (di3)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 4:
            if (di4)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 5:
            if (di5)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 6:
            if (di6)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 7:
            if (di7)
                return ID_DIGITAL_ON;
            else
                return ID_DIGITAL_OFF;
        case 8:
            if (EntradasConfigurables[0]==DIGITAL)
                if (di8)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
            else
                return E_NOTIPO;
        case 9:
            if (EntradasConfigurables[1]==DIGITAL)
                if (di9)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
            else
                return E_NOTIPO;
        case 10:
            if (EntradasConfigurables[2]==DIGITAL)
                if (di10)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
            else
                return E_NOTIPO;
        case 11:
            if (EntradasConfigurables[3]==DIGITAL)
                if (di11)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
            else
                return E_NOTIPO;
        case 12:
            if (EntradasConfigurables[4]==DIGITAL)
                if (di12)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
            else
                return E_NOTIPO;
    }
    return E_NOEXIST;
}

/**
    Devuelve el estado de la entrada e.
    Si no existe devuelve E_NOEXIST.
    Si es digital, devuelve E_NOTIPO.
**/
float entradas::VerEntradaAnalogica(int e){

    switch (e){
        case 1:
            if (EntradasConfigurables[0]==DIGITAL)
                return E_NOTIPO;
            else
                return ai1;
        case 2:
            if (EntradasConfigurables[1]==DIGITAL)
                return E_NOTIPO;
            else
                return ai2;
        case 3:
            if (EntradasConfigurables[2]==DIGITAL)
                return E_NOTIPO;
            else
                return ai3;
        case 4:
            if (EntradasConfigurables[3]==DIGITAL)
                return E_NOTIPO;
            else
                return ai4;
        case 5:
            if (EntradasConfigurables[4]==DIGITAL)
                return E_NOTIPO;
            else
                return ai5;
    }
    return E_NOEXIST;
}


//----------------------------------------------
// SALIDAS:
//----------------------------------------------
/**
    El contructor por defecto hace que todas las
    salidas configurables sean digitales.
**/

salidas::salidas(){

    InicializaSalidas();
}

/**
    Constructor con una matriz de boolean
    de tamanyo SALIDAS_CONFIGURABLES, en
    la cual se especifica el tipo de salida
    analogica o digital en su posicion adecuada.
**/
salidas::salidas(bool s[]){

    InicializaSalidas(s);
}

void salidas::InicializaSalidas(){

    int i;
    for (i=0; i<SALIDAS_CONFIGURABLES; ++i){
        SalidasConfigurables[i]=DIGITAL;
        PonSalidaDigital(i+1,false);
    }
}

void salidas::InicializaSalidas(bool s[]){

    int i;
    for (i=0; i<SALIDAS_CONFIGURABLES; ++i)
        SalidasConfigurables[i]=s[i];
    for (i=0; i<SALIDAS_CONFIGURABLES; ++i)
        if (SalidasConfigurables[i]==DIGITAL)
            PonSalidaDigital(i+1,false);
        else
            PonSalidaAnalogica(i+1,0);
}

/***
    Devuelve el tipo de salida.
    La llamada es con el numero de salida [1..MAX_SALIDAS]
***/
int salidas::TipoSalida(int s){

    if ((s<=0)||(s>MAX_SALIDAS))
        return E_NOEXIST;
    if (SalidasConfigurables[s]==DIGITAL)
        return ID_DIGITAL;
    return ID_ANALOGICA;
}

/**
    Muestra el estado de la salida s.
    Si no existe devuelve E_NOEXIST.
    Si es analogica, devuelve E_NOTIPO.
**/
int salidas::VerSalidaDigital(int s){

    switch (s){
        case 1:
            if (SalidasConfigurables[0]==ANALOGICA)
                return E_NOTIPO;
            else
                if (do1)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
        case 2:
            if (SalidasConfigurables[1]==ANALOGICA)
                return E_NOTIPO;
            else
                if (do2)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
        case 3:
            if (SalidasConfigurables[2]==ANALOGICA)
                return E_NOTIPO;
            else
                if (do3)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
        case 4:
            if (SalidasConfigurables[3]==ANALOGICA)
                return E_NOTIPO;
            else
                if (do4)
                    return ID_DIGITAL_ON;
                else
                    return ID_DIGITAL_OFF;
    }
    return E_NOEXIST;
}


/**
    Muestra el estado de la salida s.
    Si no existe devuelve E_NOEXIST.
    Si es digital, devuelve E_NOTIPO.
**/
int salidas::VerSalidaAnalogica(int s){

    float f;
    switch (s){
        case 1:
            if (SalidasConfigurables[0]==ANALOGICA)
                f=ao1;
            else
                return E_NOTIPO;
            break;
        case 2:
            if (SalidasConfigurables[1]==ANALOGICA)
                f=ao2;
            else
                return E_NOTIPO;
            break;
        case 3:
            if (SalidasConfigurables[2]==ANALOGICA)
                f=ao3;
            else
                return E_NOTIPO;
            break;
        case 4:
            if (SalidasConfigurables[3]==ANALOGICA)
                f=ao4;
            else
                return E_NOTIPO;
            break;
        default:
            return E_NOEXIST;
    }
    return (int)f*100;
}

/**
 Pone la salida digital s al valor b.
 Devuelve verdadero si Ok y falso si s
 no existe o no es digital.
**/
bool salidas::PonSalidaDigital(int s,bool b){

    if (s>MAX_SALIDAS)
        return false;
    switch (s){
        case 1:
            if (SalidasConfigurables[0]==ANALOGICA)
                return false;
            else do1=b;
            break;
        case 2:
            if (SalidasConfigurables[1]==ANALOGICA)
                return false;
            else do2=b;
            break;
        case 3:
            if (SalidasConfigurables[2]==ANALOGICA)
                return false;
            else do3=b;
            break;
        case 4:
            if (SalidasConfigurables[3]==ANALOGICA)
                return false;
            else do4=b;
            break;
        default:
            return false;
    }
    return true; //Todo OK.
}

/**
 Pone la salida analogica s al valor v.
 El valor v debe de estar dado en tanto por cien, es
 decir comprendido entre 0 y 100. Si no es as�,
 se manipula convenientemente.
 Devuelve verdadero si Ok y falso si s
 no existe o no es analogica.
**/
bool salidas::PonSalidaAnalogica(int s,float v){

    float i;
    if (v<0)
        i=0;
    else
        if (v>100)
            i=1;
        else
            i=v/100;    
    switch (s){
        case 1:
            if (SalidasConfigurables[0]==DIGITAL)
                return false;
            else ao1=i;
            break;
        case 2:
            if (SalidasConfigurables[1]==DIGITAL)
                return false;
            else ao2=i;
            break;
        case 3:
            if (SalidasConfigurables[2]==DIGITAL)
                return false;
            else ao3=i;
            break;
        case 4:
            if (SalidasConfigurables[3]==DIGITAL)
                return false;
            else ao4=i;
            break;
        default:
            return false;
    }
    return true; //Todo OK.
}




