/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecocore.h
Nucleo del sistema ECOTRON.
Definicion de las funciones propias
de la clase ecocore.
Esta clase es la encargada de manipular
el hardware del ecotron.
************************************/

#include "mbed.h"
#include "ecotron_es.h"

#ifndef _ECOCORE
#define _ECOCORE

#define EVENTO_ANALOGICO 3 //Por defecto, un evento analogico se da con una variacion del +-3%.
#define DEF_TIEMPO_ESPERA_TX 300 //Cada 5 minutos por defecto se efectua una Tx del estado.
#define TIEMPO_TESTBAT    300 //Por defecto el test de bateria dura un maximo de 5 minutos.
#define FRECUENCIA_TEST_BAT 43200 //Por defecto, el test de bateria se realiza cada mes.
#define MAX_TIEMPO_TESTBAT 1800 //Duracion maxima del test de la bateria 30 minutos.
#define MIN_TIEMPO_TESTBAT 10  //Duracion minima del test de la bateria 10 seundos.
#define MAX_FRECUENCIA_TESTBAT 65535 //Maximo tiempo en minutos entre test de bateria.
#define MIN_FRECUENCIA_TESTBAT 1440 //Frecuencia maxima de un test al dia.

class ecocore {

public:
    ecocore(); //Constructor.
    bool Evento();   //Devuelve verdadero si se produce un evento.
    //Las funciones del test de la bateria no se disenyan en la version de prueba.
    void IniciarTestBateria();  //Inicia el test de la bateria.
    void FinalizarTestBateria();    //Finaliza el test de la bateria.
    int EstadoBateria();    //Devuelve el estado de la bateria interna en %.
    void GuardaDatos(); //Guarda los dartos E/S en flash.
    void ReiniciarCuenta(); //Reinicia la cuenta para la expiracion de tiempo de transmision.
    bool LeeDatos(); //Lee los datos de E/S de la flash.
    bool ExpiradoTiempoTx(); //Mira si ha expirado el tiempo para una trasnmision.
    entradas *entrada;
    salidas *salida;
    
private:
    int EntradaDigital[MAX_ENTRADAS]; //Matriz para los estados de las entradas digitales.
    float EntradaAnalogica[ENTRADAS_CONFIGURABLES]; //Matriz para los estados de las entradas analogicas.
    bool SalidaDigital[MAX_SALIDAS]; //Matriz para los estados de las salidas digitales.
    int SalidaAnalogica[SALIDAS_CONFIGURABLES];
    int NivelEventoAnalogico[ENTRADAS_CONFIGURABLES]; //Valores para generar un evento en %.
    bool EventoAnalogico(int i); //Determina si hay evento analogico de la entrada i.
    int FrecuenciaTestBateria;
    Ticker tmp;

/*************************************************************************************
    Hay que definir una clase nueva para trabajar con el bus de 1 wire.
    Para este bus usaremos el pin p29
*************************************************************************************/
    
};

#endif


