/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecocore.cpp.
Nucleo del sistema ECOTRON.
Disenyo de las funciones propias
de la clase ecocore.
Esta clase es la encargada de manipular
el hardware del ecotron.
************************************/

#include "ecocore.h"

bool EventoActivo;
bool TestBateria;    //Indica si debe hacerse o no el test de la bateria.
bool ExpiradoTx; //Indica si ha expirado el tiempo para la tx.

int ContadorDecimas; //Contador de decimas de segundo.
int ContSegundos;
int EsperaAntiRebotes;
int TranscurridoTx; //Cuenta el tiempo para la Tx general.
int ContMinutos;
int TranscurridoTestBateria; //Cuenta el tiempo para el test de la bateria.
int TiempoEsperaTx;
int TiempoTestBateria;

AnalogIn aiBat(p20);    //Entrada analogica para monitorizar la bateria interna.

void FuncionTemporizador(){

    ++ContadorDecimas;
    if (ContadorDecimas>=10){
        ContadorDecimas=0;
        ++ContSegundos;
    }
    if (EventoActivo){// Control de la fecuencia de eventos.
        ++EsperaAntiRebotes;
        if (EsperaAntiRebotes>=3){ //300 milisegundos.
            EsperaAntiRebotes=0;
            EventoActivo=false;
        }
    }
    if (!ExpiradoTx) //Si no ha expirado el tiempo de transmision, incrementarlo.
        ++TranscurridoTx;
    if (ContSegundos>=60){
        ContSegundos=0;
        ++ContMinutos;
    }
    if (TestBateria){
        ++TranscurridoTestBateria;
        if (TranscurridoTestBateria>=TiempoTestBateria){
            TranscurridoTestBateria=0;
            TestBateria=false;
            ContMinutos=0; //Reiniciamos la cuenta para el siguiente test.
        }
    }
    if (ContMinutos>=TiempoTestBateria){ //Realizar el test!
        ContMinutos=0;
        if (!TestBateria)
            TestBateria=true;
    }
    if (TranscurridoTx>=TiempoEsperaTx){
        TranscurridoTx=0;
        ExpiradoTx=true;
    }
}

ecocore::ecocore() {

    //POR DEFECTO, SE ASUMEN TODAS LAS ENTRADAS Y SALIDAS DIGITALES.
    int i;
    entrada=new entradas(); //Asignaciones E/S por defecto: todas digitales.
    salida=new salidas();
    TiempoEsperaTx=DEF_TIEMPO_ESPERA_TX;
    TranscurridoTx=0;
    TiempoTestBateria=TIEMPO_TESTBAT;
    TranscurridoTestBateria=0;
    FrecuenciaTestBateria=FRECUENCIA_TEST_BAT;
    ContSegundos=0;
    ContMinutos=0;
    ContadorDecimas=0;
    EsperaAntiRebotes=0;
    TestBateria=false;
    ExpiradoTx=false;
    EventoActivo=false;
    tmp.attach(&FuncionTemporizador,0.1); //Temporizador a 100 milisegundos.
    for (i=0; i<MAX_ENTRADAS; ++i)
        EntradaDigital[i]=ID_DIGITAL_OFF;
    for (i=0; i<ENTRADAS_CONFIGURABLES; ++i){
        EntradaAnalogica[i]=0.0;
        NivelEventoAnalogico[i]=EVENTO_ANALOGICO;
    }
}

bool ecocore::Evento(){

    int i,t,e;
    if (EventoActivo) //Si estamos esperando el antirebotes, no hay evento.
        return false;
    for (i=1; i<=MAX_ENTRADAS; ++i){
        //Deteccion de evento segun tipo de entrada y estado anterior.
        t=entrada->TipoEntrada(i);
        switch (t){
            case ID_DIGITAL:
                e=entrada->VerEntradaDigital(i);
                if (e!=EntradaDigital[i]){ //Evento digital!.
                    EntradaDigital[i]=e;
                    EventoActivo=true;
                    return true;
                }
                break;
            case ID_ANALOGICA:
                if (EventoAnalogico(i)){
                    EventoActivo=true;
                    return true;
                }
                break;
            default:
                return false;
        }
    }
    return false;
}


void ecocore::ReiniciarCuenta(){

    TranscurridoTx=0;
}

bool ecocore::ExpiradoTiempoTx(){

/*
    Esto lo hacemos como sigue para que si expira el tiempo, siempre permanezca
    indicado por el flag a menos que se inspeccione mediante esta funcion.
    De otro modo, al expirar el tiempo de Tx, la indicacion o flag permaneceria
    activada solo durante un segundo.
    En esta funcion, conjuntamente con el comportamiento en el temporizador,
    conseguimos que si el tiempo expira, permanece siempre indicado por la
    variable ExpiradoTx hasta que se usa esta funcion, la cual reestablece
    su valor a false para que se reinicie la cuenta de tiempo devolviendo true.
*/    
    if (!ExpiradoTx)
        return false;
    ExpiradoTx=false;
    return true;        
}

//Las funciones del test de la bateria no se disenyan en la version de prueba.
void ecocore::IniciarTestBateria(){}  //Inicia el test de la bateria.
void ecocore::FinalizarTestBateria(){}    //Finaliza el test de la bateria.
int ecocore::EstadoBateria(){ return 0;}    //Devuelve el estado de la bateria interna en %.

void ecocore::GuardaDatos(){} //Guarda los dartos E/S en flash.
bool ecocore::LeeDatos(){ return true;} //Lee los datos de E/S de la flash.

bool ecocore::EventoAnalogico(int i){

    float f1,f2;
    bool evento=false;
    f1=entrada->VerEntradaAnalogica(i);
    if ((f1!=E_NOEXIST)&&(f1!=E_NOTIPO)){
        f2=(f1*NivelEventoAnalogico[i])/100;
        if ((f1>(EntradaAnalogica[i]+f2))||
            (f1<(EntradaAnalogica[i]-f2))){ //Evento analogico!.
            EntradaAnalogica[i]=f1; //Guardamos el nuevo dato.
            evento=true;
        }
    }
    return evento;
}





