/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecocommand.h
Definiciones para la clase ecocommand.
************************************/

#include "mbed.h"
#include "ecotron_es.h"

#ifndef _ECOCOMMAND
#define _ECOCOMMAND

#define MAX_COD 128 //Numero maximo de caracteres para el buffer.
#define NUMCOMMANDSRX 12 //Numero de comandos validos para recepcion.
#define NUMCOMMANDSTX 6 //Numero de comandos validos para transmision.
#define NUMESTADOS 5 //Numero de estados de la maquina.
#define ERROR_COD -1    //Error, codigo desconocido.
#define ERROR_PAR    -2 //Error, parametros inesperados.

  //Definiciones de estado segun texto asociado:
#define ESTADO_OK 0
#define ESTADO_PARAMS 1
#define ESTADO_COMAND 2
#define ESTADO_FORCEBATT 3
#define ESTADO_LOBATT 4

#define COMANDO_VER 0
#define COMANDO_CHX 1
#define COMANDO_CHN 2
#define COMANDO_CHF 3
#define COMANDO_CHK 4
#define COMANDO_OUD 5
#define COMANDO_OUA 6
#define COMANDO_IND 7
#define COMANDO_INA 8
#define COMANDO_INX 9
#define COMANDO_TOT 10
#define COMANDO_TTX 11

class ecocommand {
public:
    ecocommand();
    char *EstadoActual();
 //Le enviamos un comando y nos devuelve null si no puede interpretar el comando c
 // o una cadena valida para ser enviada como constestacion a dicho comando.
    char *InterpretarComando(char *c, entradas *e, salidas *s);


private:
    int NumSalida(char *c);
    void VerOpcionSalidaDigital(int i, char *c, salidas *s);
    void VerOpcionSalidaAnalogica(int i,char *c, salidas *s);
    void VerEntradasDigitales(entradas *e);
    void VerEntradasAnalogicas(entradas *e);
    void VerEntradas(entradas *e);
    void InformeGlobal(entradas *e,salidas *s);
    int VerComandoRx(char *c); //Devuelve el codigo del comando c o un codigo de error.
    int Estado;
    char buffer[MAX_COD]; //Cadena de caracteres para devolver como dato solicitado.
}; //Final de la clase ecocommand.

#endif

