/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecocommand.cpp
Clase para la interpretacion de comandos
************************************/

#include "mbed.h"
#include "ecocommand.h"


char *estados[NUMESTADOS]={"OK","PARAMS","COMAND","FORCEBATT","LOBATT"};

char *comandoRx[NUMCOMMANDSRX]={"$VM+VER?","$VM+CHKBAT=?","$VM+CHKBAT=ON","$VM+CHKBAT=OFF",
"$VM+CHKBAT=","$VM+OUT#","$VM+OUT%","$VM+IN#?","$VM+IN%?","$VM+IN?","$VM+?","$VM+TX="};

char *comandoTx[NUMCOMMANDSTX]={"IN#","IN%","H=1.0/S=0.1","OUT#","OUT%","STATUS("};


ecocommand::ecocommand(){

    Estado=ESTADO_OK;
}

char *ecocommand::EstadoActual(){

    switch(Estado){
        case ESTADO_OK:
        case ESTADO_PARAMS:
        case ESTADO_COMAND:
        case ESTADO_FORCEBATT:
        case ESTADO_LOBATT:
            return estados[Estado];
    }
    return NULL;
}

char *ecocommand::InterpretarComando(char *c, entradas *e, salidas *s){

    int i=VerComandoRx(c);
    if (i==ERROR_COD){
        Estado=ESTADO_COMAND;
        return NULL;
    }
    switch (i){
        case COMANDO_VER:
            Estado=ESTADO_OK;
            sprintf(buffer,"H=1.0/S=1.0");
            break;
        case COMANDO_CHX:
        case COMANDO_CHN:
        case COMANDO_CHF:
        case COMANDO_CHK: //No hay bateria en la version actual.
            Estado=ESTADO_PARAMS;
            break;
        case COMANDO_OUD:
            i=NumSalida(c);
            Estado=ESTADO_OK;
            VerOpcionSalidaDigital(i,c,s);
            break;
        case COMANDO_OUA:
            i=NumSalida(c);
            Estado=ESTADO_OK;
            VerOpcionSalidaAnalogica(i,c,s);
            break;
        case COMANDO_IND:
            Estado=ESTADO_OK;
            VerEntradasDigitales(e);
            break;
        case COMANDO_INA:
            Estado=ESTADO_OK;
            VerEntradasAnalogicas(e);
            break;
        case COMANDO_INX:
            Estado=ESTADO_OK;
            VerEntradas(e);
            break;
        case COMANDO_TOT:
            Estado=ESTADO_OK;
            InformeGlobal(e,s);
            break;
        case COMANDO_TTX:
            Estado=ESTADO_OK;
            //Guardar el numero en flash.
            sprintf(buffer,"STATUS(OK)");
            break;
        default:
            Estado=ESTADO_COMAND;
    }
    switch (Estado){
        case ESTADO_COMAND:
            sprintf(buffer,"STATUS(COMAND)");
            break;
        case ESTADO_PARAMS:
            sprintf(buffer,"STATUS(PARAMS)");
            break;
        default:
            return buffer;
    }
    return buffer;
}


int ecocommand::VerComandoRx(char *c){

    int i;
    for (i=0; i<NUMCOMMANDSRX; ++i)
        if (!strcmp(c,comandoRx[i]))
            return i;
    return ERROR_COD;
}

/****
    Esta funcion averigua el numero de salida pasado
    como texto en el comando c. Si no es un numero valido
    devuelve ERROR_PARAMS.
****/
int ecocommand::NumSalida(char *c){

    int i;
    char n[3];
    n[0]=c[8];
    n[1]=c[9];
    n[2]='\x0';
    i=atoi(n);
    if (i<=0)
        return ERROR_PAR;
    return i;
}

/****
    Devuelve la cadena correspondiente a las distintas
    opciones posibles de entrada como son "?", "=ON", "=OFF",
    para la salida numero i.
    Si la salida i no existe, devuelve null.
    Si las opciones no son vlaidas, devuelve null.
****/
void ecocommand::VerOpcionSalidaDigital(int i,char *c, salidas *s){

    if (!strcmp(&c[10],"=?")){
        switch (s->VerSalidaDigital(i)){
            case E_NOTIPO:
            case E_NOEXIST:
                Estado=ESTADO_PARAMS;
                return;
            case ID_DIGITAL_ON:
                Estado=ESTADO_OK;
                sprintf(buffer,"OUT#%d=ON",i);
                return;
            case ID_DIGITAL_OFF:
                Estado=ESTADO_OK;
                sprintf(buffer,"OUT#%d=OFF",i);
                return;
            default:
                Estado=ESTADO_PARAMS;
                return;
        }
    }
    if (!strcmp(&c[10],"=ON")){
        if (s->PonSalidaDigital(i,true)){
            Estado=ESTADO_OK;
            sprintf(buffer,"OUT#%d=ON",i);
            return;
        }
        else{
            Estado=ESTADO_PARAMS;
            return;
        }
    }
    if (!strcmp(&c[10],"=OFF")){
        if (s->PonSalidaDigital(i,false)){
            Estado=ESTADO_OK;
            sprintf(buffer,"OUT#%d=OFF",i);
            return;
        }
        else{
            Estado=ESTADO_PARAMS;
            return;
        }
    }
    Estado=ESTADO_PARAMS;
}


void ecocommand::VerOpcionSalidaAnalogica(int i,char *c,salidas *s){

    int j;
    float f;
    if (!strcmp(&c[10],"=?")){
        j=s->VerSalidaAnalogica(i);
        switch (j){
            case E_NOTIPO:
            case E_NOEXIST:
                Estado=ESTADO_PARAMS;
                return;
            default:
                Estado=ESTADO_OK;
                sprintf(buffer,"OUT%%%d=%d",i,j);
                return;
        }
    }
    f=atof(&c[11]); //f= valor requerido en la salida.
    if (s->PonSalidaAnalogica(i,f)){
        Estado=ESTADO_OK;
        sprintf(buffer,"OUT%%%d=%f.1",i,f);
        return;
    }
    Estado=ESTADO_PARAMS;
}

 void ecocommand::VerEntradasDigitales(entradas *e){

    int i;
    char bufferLocal[8];
    sprintf(buffer,"IN#={");
    for (i=0; i<MAX_ENTRADAS; ++i)
        if (e->TipoEntrada(i)==ID_DIGITAL){
            if (e->VerEntradaDigital(i)==ID_DIGITAL_ON)
                sprintf(bufferLocal,"%d=1",i);
            else
                sprintf(bufferLocal,"%d=0",i);
            strcat(buffer,bufferLocal);
            if (i<MAX_ENTRADAS-1)
                strcat(buffer,";");
        }
    strcat(buffer,"}");
}

void ecocommand::VerEntradasAnalogicas(entradas *e){

    int i;
    float f;
    char bufferLocal[8];
    sprintf(buffer,"IN%={");
    for (i=0; i<MAX_ENTRADAS; ++i)
        if (e->TipoEntrada(i)==ID_ANALOGICA){
            f=e->VerEntradaAnalogica(i);
            sprintf(bufferLocal,"%d=%f.1",i,f);
            strcat(buffer,bufferLocal);
            if (i<MAX_ENTRADAS-1)
                strcat(buffer,";");
        }
    strcat(buffer,"}");
}

void ecocommand::VerEntradas(entradas *e){

    char bufferLocal[MAX_COD];
    VerEntradasDigitales(e);
    strcpy(bufferLocal,buffer);
    VerEntradasAnalogicas(e);
    strcat(bufferLocal,buffer);
    strcpy(buffer,bufferLocal);
}

void ecocommand::InformeGlobal(entradas *e, salidas *s){

    char bufferLocal[MAX_COD];
    int i;
    VerEntradas(e);
    strcpy(bufferLocal,buffer);
    for (i=0; i<MAX_SALIDAS; ++i){
        if (s->TipoSalida(i+1)==ID_DIGITAL){
            VerOpcionSalidaDigital(i+1,"$VM+OUT#nn=?",s);
            strcat(bufferLocal,buffer);
        }
        else{
            VerOpcionSalidaAnalogica(i+1,"$VM+OUT%nn=?",s);
            strcat(bufferLocal,buffer);
        }
        strcat(bufferLocal,";");
    }
    strcpy(buffer,bufferLocal);
}
