/************************************
Software del mbed para el Ecotron.
(c) Miquel Carbonell Piqueres
Diciembre de 2011.
************************************/
/************************************
Arhivo: ecocom.cpp
Disenyo de la clase para el puerto
de comunicaciones serie empleado en 
el sistema Ecotron.
************************************/

#include "ecocom.h"

ecocom::ecocom(): Serial (p28,p29){ //Pins de E/S del Ecotron.

    baud(57600); //Velocidad convenida por defecto.
    format(8,Serial::None,1); //8 bits por palabra, sin paridad y 1 bit de parada.
    posChar=0;
    RxCompleta=false;
    attach(this,&ecocom::RxDatos,Serial::RxIrq);
}

void ecocom::TxDatos(char *c){

    if (c==NULL)
        return;
    printf("$WP+DCMSG=%s\r\n",c);
    
}

void ecocom::RxDatos(){

    char c;
    while (readable()){
        c=getc();
        RxBuffer[posChar++]=c;
        if ((posChar==(MAX_CAD-1))||((c=='\r')||(c=='\n'))){
            //Ignorar cadenas vacias:
            if (((c=='\r')||(c=='\n'))&&(posChar==1)){
                posChar=0;
                return;
            }
            RxBuffer[posChar]='\x0';
            posChar=0;
            sprintf(RxCad,RxBuffer);
            RxCompleta=true;
            break;
        }
    }
}

