#include "protocol.h"

char newDataAvailable = 0;

//Bytewise XOR
char calculateChecksum(uint32_t propulsion, uint32_t direction)
{
    char checksum = 0xff;
    checksum ^= propulsion >> 8;
    checksum ^= propulsion & (0b11111111);
    checksum ^= direction >> 8;
    checksum ^= direction & (0b11111111);
    
    return checksum;
}

char receiveState = STATE_START_OF_FRAME;
char receiveIndex = 0;
uint32_t receivedPropulsion;
uint32_t receivedDirection;

uint32_t verifiedPropulsion = 1500;
uint32_t verifiedDirection = 1150;

//Decode the bytes received according to their order of reception.
void decodeMessage(char c)
{
    switch(receiveState)
    {
        case STATE_START_OF_FRAME:
            //Checking if we received the start Byte
            if (c == 0xff)
            {
                receiveState = STATE_PROPULSION;
                receiveIndex = 0;
            }
            break;
            
        case STATE_PROPULSION:
            //Retrieving the propulsion PWM bytes (1. MSB; 2. LSB)
            if (receiveIndex++ == 0)
                receivedPropulsion = c << 8;
            else
            {
                receivedPropulsion += c;
                receiveState = STATE_DIRECTION;
                receiveIndex = 0;
            }
            break;
            
        case STATE_DIRECTION:
            //Retrieving the direction PWM bytes (1. MSB; 2. LSB)
            if (receiveIndex++ == 0)
                receivedDirection = c << 8;
            else
            {
                receivedDirection += c;
                receiveState = STATE_CHECKSUM;
            }
            break;
            
        case STATE_CHECKSUM:
            //Checksum
            if (c == calculateChecksum(receivedPropulsion, receivedDirection))
            {
                //The frame is correct, we can use the values retrieved.
                verifiedPropulsion = receivedPropulsion;
                verifiedDirection = receivedDirection;
                newDataAvailable = 1;
            }
            receiveState = STATE_START_OF_FRAME;
            break;
            
        default:
            receiveState = STATE_START_OF_FRAME;
            break;
    }
}

//Return the values decoded
void getVerifiedPWMValues(uint32_t *pwmPropulsion, uint32_t *pwmDirection)
{
    *pwmPropulsion = verifiedPropulsion;
    *pwmDirection = verifiedDirection;
    newDataAvailable = 0;
}

//Return a value telling if new informations are available.
char isDataAvailable()
{
    return newDataAvailable;
}
