/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "protocol.h"

//Define SPI
#define SPI3_MOSI   D11
#define SPI3_MISO   D12
#define SPI3_SCLK   D13
#define SPI3_CS     A3

//Define PWM
#define PWM_PROP    D9
#define PWM_DIR     D10

//fontion interrupt SP
void onRxInterrupt();

//Declaration PWM outputs
PwmOut propulsion(PWM_PROP);
PwmOut direction(PWM_DIR);

//Declaration Links
static UnbufferedSerial serial_port(USBTX, USBRX,115200);
SPISlave device(SPI3_MOSI, SPI3_MISO, SPI3_SCLK, SPI3_CS); // mosi, miso, sclk, ssel

int main()
{
    //Declaration PWM variables
    uint32_t pulsewidth_direction = 1100;
    uint32_t pulsewidth_propulsion = 1500;
    
    //Test Serial port
    serial_port.write("Test\n\r",strlen("Test\n\r"));
    
    //Interrupt SP
    serial_port.attach(&onRxInterrupt, SerialBase::RxIrq);
    
    //Init. propulsion PWM
    propulsion.period_us(20000);
    propulsion.pulsewidth_us(pulsewidth_propulsion);
    
    thread_sleep_for(2000);
    
    //Init. Direction PWM
    direction.period_us(20000);
    direction.pulsewidth_us(pulsewidth_direction);
    
    //Init. SPI Link
    device.format(8);
    
    //Infinite loop
    while(1) 
    {
        //If SPI received a char, decode it then reply bullshit.
        if(device.receive())
        {
            char c = device.read();
            decodeMessage(c);
            serial_port.write(&c, 1);
            device.reply(0b10101010);
        }
        
        //If decoding has ended, get and changes PWM values.
        if(isDataAvailable())
        {
            getVerifiedPWMValues(&pulsewidth_propulsion, &pulsewidth_direction);
            propulsion.pulsewidth_us(pulsewidth_propulsion);
            direction.pulsewidth_us(pulsewidth_direction);
        }        
        
    }
}

void onRxInterrupt()
{
    char c;


    // Read the data to clear the receive interrupt.
    if (serial_port.read(&c, 1)) {
        decodeMessage(c);
        serial_port.write(&c, 1);
    }

}