#ifndef PROTOCOL_H
#define PROTOCOL_H

#include "mbed.h"

#define PAYLOAD_MAX_SIZE 128

#define STATE_START_OF_FRAME    0
#define STATE_COMMAND_TYPE      1 
#define STATE_PAYLOAD           2
#define STATE_CHECKSUM          3

#define COMMAND_PWM             0b10101010
#define COMMAND_ASSERVISSEMENT  0b01010101
#define COMMAND_PARAMETRES      0b10100101


char calculateChecksum(char command, char* payload, char payloadLength);
char calculateChecksum(char *msg);
void encodeMessage(char *msg, float vitesse);
void decodeMessage(char c);
char getVerifiedPayload(char *payloadOutput);
char isDataAvailable();

#endif