#include "protocol.h"
#include "toolbox.hpp"

char newDataAvailable = 0;

//Bytewise XOR checksum
char calculateChecksum(char command, char* payload, char payloadLength) //Use only when receiving frames
{
    char checksum = 0xff;
    checksum ^= command;
    for (int i = 0; i < payloadLength; i++)
        checksum ^= payload[i];
    return checksum;
}

char calculateChecksum(char *msg) //Use only when emitting speed frames
{
    int i = 0;
    char checksum = msg[i++];
    for (; i < 5; i++)
        checksum ^= msg[i];
    return checksum;
}

void encodeMessage(char *msg, float vitesse)
{
    msg[0] = 0xff;
    convertFloatToBytes(&vitesse, msg, 1);
    msg[5] = calculateChecksum(msg); 
}

char receiveState = STATE_START_OF_FRAME;
char receiveIndex = 0;
char receiveIndexLimit;
char receivedCommand;
char receivedPayload[PAYLOAD_MAX_SIZE] = {0};

char verifiedPayload[PAYLOAD_MAX_SIZE] = {0};
char verifiedIndexLimit;
char verifiedCommand;

//Decode the bytes received according to their order of reception.
void decodeMessage(char c)
{
    switch(receiveState)
    {
        case STATE_START_OF_FRAME:
            //Checking if we received the start Byte
            if (c == 0xff)
            {
                receiveState = STATE_COMMAND_TYPE;
                receiveIndex = 0;
            }
            break;
            
        case STATE_COMMAND_TYPE:
            receivedCommand = c;
            receiveState = STATE_PAYLOAD;
            switch(receivedCommand)
            {
                case COMMAND_PWM:
                    receiveIndexLimit = 4;
                    break;
                    
                case COMMAND_ASSERVISSEMENT:
                    receiveIndexLimit = 6;
                    break;
                    
                case COMMAND_PARAMETRES:
                    receiveIndexLimit = 8;
                    break;
                
                default:
                    receiveState = STATE_START_OF_FRAME;
                    break;
            }
            break;
            
        case STATE_PAYLOAD:
            receivedPayload[receiveIndex++] = c;
            if (receiveIndex >= receiveIndexLimit)
                receiveState = STATE_CHECKSUM;
            break;
                
        case STATE_CHECKSUM:
            //Checksum
            if (c == calculateChecksum(receivedCommand, receivedPayload, receiveIndexLimit))
            {
                //The frame is correct, we can use the values retrieved.
                for (int i = 0; i < receiveIndexLimit; i++)
                    verifiedPayload[i] = receivedPayload[i];
                verifiedIndexLimit = receiveIndexLimit;
                verifiedCommand = receivedCommand;
                newDataAvailable = 1;
            }
            receiveState = STATE_START_OF_FRAME;
            break;
            
        default:
            receiveState = STATE_START_OF_FRAME;
            break;
    }
}

//Return the values decoded
char getVerifiedPayload(char *payloadOutput)
{
    for (int i = 0; i < verifiedIndexLimit; i++)
        payloadOutput[i] = verifiedPayload[i];
    newDataAvailable = 0;
    return verifiedCommand;
}

//Return a value telling if new informations are available.
char isDataAvailable()
{
    return newDataAvailable;
}
