#include "asservissement.hpp"
#include "toolbox.hpp"

double kp = 1;
double ki = 1;
double errorIntegral = 0;
double integralLimit = 10;

uint32_t PID(double error, double sampleRate)
{
    errorIntegral += error / sampleRate;
    errorIntegral = limitToInterval(errorIntegral, -integralLimit, integralLimit);
    double correction = kp * error + ki * errorIntegral;
    double correctionPWM = SPEED_TO_PWM_TRANSFORM(correction);
    return limitToInterval(correctionPWM, 1000, 1500);
}

void setPIDParameters(double kp_, double ki_)
{
    kp = kp_;
    ki = ki_;
}