// MW771 Laser Press HMI.
// V.Nemera, 10/07/2016, ver.1.0, C++
// CPU: mbed NXP LPC1768 (ARM Cortex-M3, 32bit, 90MHz)
//#pragma once
#ifndef MAIN_H_
#define MAIN_H_

//main screen
typedef struct {
    uint16_t x1;
    uint16_t y1;
    uint16_t x2;
    uint16_t y2;
    uint16_t textX;
    uint16_t textY;
    color_t color;
    color_t textColor;
    char text[40];
    //char * text;
} TextBox;

typedef struct {
    uint16_t wMode;     //0-circle, 1-Eight, 2-Infinity
    uint16_t LPbeg;     //welding laser power begin [%] 10..100
    uint16_t LPend;     //welding laser power end [%] 10..100
    uint16_t Lmode;     //0-CW, 1-Pulse
    uint16_t Lfreq;     //laser frequency [Hz] 1..1000
    uint16_t Lpulse;    //laser pulse length [%] 1..100 
    uint16_t amplBeg;   //wobbles begin amplitude [0.1mm] 1..99 (0.1-9.9mm)
    uint16_t amplEnd;   //wobbles end amplitude [0.1mm] 1..99 (0.1-9.9mm)
    uint16_t wFreq;     //wobbles frequency [Hz] 1..300
    uint16_t wTime;     //wobbles time [mS] 1..5000
    uint16_t amplNum;   //number of amplitude steps 1..100 (min step 0.1mm)
} ProgPar; 

typedef struct {
    uint16_t x1;
    uint16_t y1;
    uint16_t x2;
    uint16_t y2;
    uint16_t r1;
    uint16_t r2;
    uint16_t textX;
    uint16_t textY;
    color_t color;
    color_t textColor;
    char text[16];
} TextBoxR;

typedef char TPstring[24]; 
                  
typedef struct {
    uint16_t min;
    uint16_t max;
} MinMax; 

typedef struct {
    char o3[4];     //io outputs d15-d0
    char o2[4];     //io outputs d31-d16
    char o1[4];     //io outputs d31-d16
    char i3[4];     //io inputs d15-d0
    char i2[4];     //io inputs d31-d16
    char i1[4];     //io inputs d31-d16
    char aiLPow[4];   //analog laser power
    char aiLCur[4];   //analog laser current
    char aiLTemp[4];  //analog laser temp
    char aiLBR[4];    //analog laser back reflection
} IOPar; 

#endif  /* inclusion lock */







