// MW771 Laser Press HMI.
// V.Nemera, 10/12/2016, ver.1.0, C++
// CPU: mbed NXP LPC1768 (ARM Cortex-M3, 32bit, 90MHz)

#include "RA8875.h"         
#include "main.h"         
#include "comm.h"         

//-----------HMI i/o---------------------
DigitalIn inEStop(p19);     //input: E-Stop ON = 1
DigitalIn inBtnStart(p20);  //input: Btn Start ON = 0
DigitalIn inLPactive(p26);  //input: Laser power active = 1
DigitalIn in1(p24);         //input: in1 ON = 0
DigitalIn in2(p23);         //input: in2 ON = 0

DigitalOut outIrq(p14);         //output: interrupt for IO
DigitalOut outLampStart(p25);   //output: Start Lamp ON = 1
DigitalOut out1(p22);           //output: out1 ON = 1
DigitalOut out2(p21);           //output: out2 ON = 1

Ticker resetTime;                //time for e-stop reset pulse

int iCh;
char hexArr[] = "0123456789ABCDEF";
const char err100[] = "Wrong command\n";
const char err101[] = "No response\n";

Serial ioRS232(p28, p27);  // tx, rx
int     ioRS232baud = 115200;
int     ioRS232bits = 8;
SerialBase::Parity  ioRS232parity = SerialBase::None;
int     ioRS232stop_bits = 1; 

Serial LasRS232(p9, p10);  // tx, rx
int     LasRS232baud = 57600;
int     LasRS232bits = 8;
SerialBase::Parity  LasRS232parity = SerialBase::None;
int     LasRS232stop_bits = 1; 

char hmiLBuf[64];   //buffer hmi command to send to laser

int indLhmi = 0;       //index of buffer hmiLBuf[]

char LasBufCom[64];   //buffer command to send to laser
char LasBufResp[64];  //buffer response from laser

int indLCom = 0;       //index of buffer LasBufCom[]
int indLResp = 0;      //index of buffer LasBufResp[]

char IOBufCom[32];   //buffer command from io controller
char IOBufResp[32];  //buffer response to send to io controller

int indIOCom = 0;       //index of buffer IOBufCom[]
int IOBufSize = 32;      //buffer IOBufResp[] size
int sBio = 0;           //send ioBuf pointer
int wBio = 0;           //write ioBuf pointer

char comBuf[128];      //buffer command from pc 
int comBufPointer = 0;

int sBp = 0;           //send pcBuf pointer
int wBp = 0;           //write pcBuf pointer
const int pcBufSize = 128;
char pcBuf[pcBufSize];

int stLhmi = 0;        //status of hmi L.command
int stLpc = 0;         //status of pc L.command
int iPCcmd = 0;        //command # from pc
int stL3 = 0;          //status of execution L.command
int iCounts = 0;
int iSta = 0;
int c; 
int usta;
int iLasO, iLasO1, iLasO2;
int iCmax = 10;
//=========================================================
const char *cLC[80];      //array of laser commands string

void cLCinit(void) {
    cLC[0] = "";
    cLC[1] = "STA";     //cod 0x4001 STA -   read laser status 
    cLC[2] = "RCS";     //cod 0x4002 RCS -   read current setpoint
    cLC[3] = "RNC";     //cod 0x4003 RNC -   read minimum current setpoint
    cLC[4] = "ROP";     //cod 0x4004 ROP -   read output power
    cLC[5] = "RPP";     //cod 0x4005 RPP -   read peak power
    cLC[6] = "RPW";     //cod 0x4006 RPW -   read pulse width
    cLC[7] = "RPRR";    //cod 0x4007 RPRR -  read pulse repetition rate
    cLC[8] = "RFV";     //cod 0x4008 RFV -   read current software revision
    cLC[9] = "RCT";     //cod 0x4009 RCT -   read laser temperature
    cLC[10] = "RET";    //cod 0x400A RET -   read elapsed time  the laser has been on
    cLC[11] = "RMEC";   //cod 0x400B RMEC -  read module error code
    cLC[12] = "RSN";    //cod 0x400C RSN -   read serial number
    cLC[13] = "REC";    //cod 0x400D REC -   read error counter
    cLC[14] = "RICDT";  //cod 0x400E RICDT - read input circuit discharge time
    cLC[15] = "RIP";    //cod 0x400F RIP -   read the current IP address
    cLC[16] = "RMASK";  //cod 0x4010 RMASK - read the current subnet mask
    cLC[17] = "RDGW";   //cod 0x4011 RDGW -  read the current default gateway address
    cLC[18] = "RMAC";   //cod 0x4012 RMAC -  read MAC address
    cLC[19] = "RBAUD";  //cod 0x4013 RBAUD - read the current RS232 baud rate
    cLC[20] = "";
    cLC[21] = "";
    cLC[22] = "";
    cLC[23] = "";
    cLC[24] = "";
    cLC[25] = "";
    cLC[26] = "";
    cLC[27] = "";
    cLC[28] = "";
    cLC[29] = "";
    cLC[30] = "";
    cLC[31] = "";
    cLC[32] = "EPM";    //cod 0x4020 EPM -   enable pulse mode
    cLC[33] = "DPM";    //cod 0x4021 DPM -   disable pulse mode
    cLC[34] = "ABN";    //cod 0x4022 ABN -   aiming beam on
    cLC[35] = "ABF";    //cod 0x4023 ABF -   aiming beam off
    cLC[36] = "EEC";    //cod 0x4024 EEC -   enable external analog power control input
    cLC[37] = "DEC";    //cod 0x4025 DEC -   disable external analog power control input
    cLC[38] = "EGM";    //cod 0x4026 EGM -   enable gate mode (internal pulse generator gated by external modulation input)
    cLC[39] = "DGM";    //cod 0x4027 DGM -   disable gate mode
    cLC[40] = "EMOD";   //cod 0x4028 EMOD -  enable external modulation input
    cLC[41] = "DMOD";   //cod 0x4029 DMOD -  disable external modulation input
    cLC[42] = "ELE";    //cod 0x402A ELE -   enable external emission input
    cLC[43] = "DLE";    //cod 0x402B DLE -   disable external emission input
    cLC[44] = "EHC";    //cod 0x402C EHC -   enable compatibility mode
    cLC[45] = "EDC";    //cod 0x402D EDC -   disable compatibility mode
    cLC[46] = "EEABC";  //cod 0x402E EEABC - enable external aiming beam control input
    cLC[47] = "DEABC";  //cod 0x402F DEABC - disable external aiming beam control input
    cLC[48] = "EWPM";   //Enable Waveform Pulse Mode
    cLC[49] = "DWPM";   //Disable Waveform Pulse Mode
    cLC[50] = "PCFG";   //Configure Waveform Mode
    cLC[51] = "RCE";    //Reset critical error
    cLC[52] = "RERR";   //Resers any resettable errors
    cLC[53] = "EMON";   //Start Emission
    cLC[54] = "EMOFF";  //Stop Emission
    cLC[55] = "";
    cLC[56] = "";
    cLC[57] = "";
    cLC[58] = "";
    cLC[59] = "";
    cLC[60] = "";
    cLC[61] = "";
    cLC[62] = "";
    cLC[63] = "";
    cLC[64] = "SDC ";    //cod 0x4040 SDC -   set diode current, min current < xx.x% < 100%
    cLC[65] = "SPW ";    //cod 0x4041 SPW -   set pulse width, xx.x mS
    cLC[66] = "SPRR ";   //cod 0x4042 SPRR -  set pulse repetition rate, xxx Hz
    cLC[67] = "SIP ";    //cod 0x4043 SIP -   set IP, xxx.xxx.xxx.xxx
    cLC[68] = "SMASK ";  //cod 0x4044 SMASK - set subnet mask, xxx.xxx.xxx.xxx
    cLC[69] = "SDGW ";   //cod 0x4045 SDGW -  set default gateway, xxx.xxx.xxx.xxx
    cLC[70] = "SMAC ";   //cod 0x4046 SMAC -  set MAC address xx-xx-xx-xx-xx-xx
    cLC[71] = "SBAUD ";  //cod 0x4047 SBAUD - set baud rate x (0-110,1-300,2-1200,3-2400,4-4800,5-9600
                        //                                    6-19200,7-38400,8-57600default,9-115200)
    cLC[72] = "PRSEL "; //Select Profile
    cLC[73] = "SQSEL "; //Select Sequence
    cLC[74] = "";
    cLC[75] = ""; 
    cLC[76] = "";
    cLC[77] = "";
    cLC[78] = "";
    cLC[79] = "";
}

//-------------------------------------------
int SetLasComm(int icLC) {
    for(int i=0; i<15; i++) {   //wait 15*20ms stLhmi=0 (last command executed)
        if(stLhmi == 0) {
            indLhmi++;
            for(int j=0; j<indLhmi; j++) {hmiLBuf[j] = '\0';}
            indLhmi = strlen(cLC[icLC]);
            strncpy(hmiLBuf, cLC[icLC], indLhmi);
            //pc.printf("-s%i %s %s %i\n", icLC, hmiLBuf, cLC[icLC], indLhmi);
            if(icLC == 1) iSta = 1;
            stLhmi = 2;
            wait_ms(20);
            return 0;        
        }
        else {
            wait_ms(20);    
        }
    }
    //pc.printf("-e%i %s %s %i\n", icLC, hmiLBuf, cLC[icLC], indLhmi);
    return 1;
}
    
void initHMIio(void) {
    ioRS232.format(ioRS232bits, ioRS232parity, ioRS232stop_bits);
    ioRS232.baud(ioRS232baud);
    
    LasRS232.format(LasRS232bits, LasRS232parity, LasRS232stop_bits);
    LasRS232.baud(LasRS232baud);
    
    outIrq = 0;         //output: interrupt for IO
    outLampStart = 0;   //output: Start Lamp ON = 1
    out1 = 0;           //output: out1 ON = 1
    out2 = 0;           //output: out2 ON = 1

    cLCinit();
    
    for(int i=0; i<64; i++) {
        LasBufCom[i] = '\0';
        LasBufResp[i] = '\0';
    }  
}
//write char to pc buffer
void wrChar(char cCh) {
    pcBuf[wBp++] = (cCh);
    if(wBp == pcBufSize) {wBp = 0;}    
}
//write char array to pc buffer
void wrCharArr(const char* err) {
    int iM;
    iM = strlen(err);
    for(int i=0; i<iM; i++) {
        wrChar(err[i]);
    }
}
//write 16bit word to pc buffer
void wrWord(uint16_t uWrd) {
    wrChar(hexArr[uWrd/4096]);
    uWrd = uWrd % 4096;    
    wrChar(hexArr[uWrd/256]);
    uWrd = uWrd % 256;    
    wrChar(hexArr[uWrd/16]);
    wrChar(hexArr[uWrd%16]);
}
//write 32bit word to pc buffer
void wrInt(int i32) {
    wrWord((uint16_t)(i32/65536));
    wrWord((uint16_t)(i32%65536));
}
    
void comParser() {
    if(comBufPointer < 2) {
        wrCharArr(err100);    //err100 = Wrong command
        wrChar('>');
        comBufPointer =0;
        return;
    }
    //pc.printf("1 %i 2 %i\n", comBuf[0], comBuf[1]); 
        
    //for (int j = 3; j < comBufPointer; j++) {
    //    pc.printf("%i %i \n", j, comBuf[j]);
    //}

    int a = comBuf[0];
    int b = comBuf[1];
    
    //-----------------------
    if (((a == 76) || (a == 108)) && (b == 32)) {  //L<SP> or l<SP>
        if(stLpc == 0) {
//            pc.printf("<%i>", comBufPointer); 
            iPCcmd = 1;
        }
        else {
            wrChar('?');
            wrChar('>');
        }            
    }
    
    //-----------------------
    else if (((a == 76) || (a == 108)) && ((b == 83) || (b == 15))) {  //LS or ls
        iPCcmd = 2;
    }
    
    //-----------------------
    else if (((a == 76) || (a == 108)) && ((b == 73) || (b == 105))) {  //LI or li
        iPCcmd = 3;
    }
    
    //----------------------- 
    else if(((a == 76) || (a == 108)) & ((b == 65) || (b == 97))) {  //LA or la
        iPCcmd = 4;
    }
    
    //----------------------- 
    else if(((a == 76) || (a == 108)) & ((b == 67) || (b == 99))) {  //LC or lc
        iPCcmd = 5;
    }
    
    //----------------------- 
    else if(((a == 76) || (a == 108)) & ((b == 82) || (b == 114))) {  //LR or lr
        iPCcmd = 6;
    }
    
    else {
        wrCharArr(err100);    //err100 = Wrong command
        wrChar('>');
        comBufPointer =0;
    }
}
//=========================================================
void wrIOChar(char cCh) {       //write 1 char to io buffer
    IOBufResp[wBio++] = (cCh);
    if(wBio == IOBufSize) wBio = 0;    
}

void wrIObyte(int iCh) {       //write byte (2 char) to io buffer
    iCh = iCh & 0xFF;
    wrIOChar(hexArr[iCh/16]);
    wrIOChar(hexArr[iCh%16]);
}

void wrIOword(uint16_t uWrd) {    //write 16bit word (4 char) to io buffer
    wrIOChar(hexArr[uWrd/4096]);
    uWrd = uWrd % 4096;    
    wrIOChar(hexArr[uWrd/256]);
    uWrd = uWrd % 256;    
    wrIOChar(hexArr[uWrd/16]);
    wrIOChar(hexArr[uWrd%16]);
}

void wrIOint(int i32) {           //write 32bit word to io buffer
    wrIOword((uint16_t)(i32/65536));
    wrIOword((uint16_t)(i32%65536));
}
void ioSt(void) {
    int b0st = 0;   //send bits d7-d4
    if(in2) b0st = b0st + 1;
    if(flagParChanged == 0) b0st = b0st + 2;
    if(flagLrsConnected) b0st = b0st + 4;
    if(flagLcomProcess) b0st = b0st + 8;
    wrIOChar(hexArr[b0st]);
        
    b0st = 0;       //send bits d3-d0
    if(inEStop) b0st = b0st + 1;
    if(inBtnStart) b0st = b0st + 2;
    if(inLPactive) b0st = b0st + 4;
    if(in1) b0st = b0st + 8;
    wrIOChar(hexArr[b0st]);
    
    wrIOChar(0xD);          //send <CR>
}

void sendIOerr(int iErr) {
    wrIOChar(hexArr[iErr | 8]); //1<err> send
    wrIOChar(0x30);             //0-status send
    ioSt();
    showTPstatus(iErr);        
}

void sendIOstatus(void) {
    uint8_t b0st = 0;
    if(flagParChanged == 0) {
        b0st = 0x0010;      //param. send request
        
        led3 = 1;
        wait_us(4);
        led3 = 0;
    }    
    else b0st = ioReq << 4;                     //another requests
    wrIObyte(b0st);

    ioSt();        
    flagParChanged = 1;
}

void sendIOpar(void) {
    int b0par;
    
    wrIOChar(0x30);   //0000-ready & no err
    wrIOChar(0x31); //1-parameters send
    
    b0par = prPar[progNumber].wMode + (prPar[progNumber].Lmode * 64);
    wrIObyte(b0par); //send mode

    wrIObyte(prPar[progNumber].LPbeg);
    wrIObyte(prPar[progNumber].LPend);
    wrIOword(prPar[progNumber].Lfreq);
    wrIObyte(prPar[progNumber].Lpulse);
    wrIObyte(prPar[progNumber].amplBeg);
    wrIObyte(prPar[progNumber].amplEnd);
    wrIObyte(prPar[progNumber].wFreq);
    wrIOword(prPar[progNumber].wTime);
    wrIObyte(prPar[progNumber].amplNum);

    wrIOChar(0xD);          //senr <CR>
    //flagParChanged = 1;
    c7 = c7 | 0x7700;
}

void sendIOout(void) {
    for(int i=0; i<2; i++) {
        ioPar.o3[i] = IOBufCom[i+2];
        ioPar.o2[i] = IOBufCom[i+4];
        ioPar.o1[i] = IOBufCom[i+6];
    }    

    if(bitOstate > 0x7F) {  //send output
        wrIOChar(0x30);     //0000-ready & no err
        wrIOChar(0x32);     //2-output send
        
        wrIObyte(bitOstate & 0x7F);        
        wrIOChar(0xD);          //senr <CR>
    }
    else sendIOstatus();
}

void sendIOinp(void) {
    for(int i=0; i<2; i++) {
        ioPar.i3[i] = IOBufCom[i+8];
        ioPar.i2[i] = IOBufCom[i+10];
        ioPar.i1[i] = IOBufCom[i+12];
        ioPar.aiLPow[i] = IOBufCom[i+14];
        ioPar.aiLCur[i] = IOBufCom[i+16];
        ioPar.aiLTemp[i] = IOBufCom[i+18];
        ioPar.aiLBR[i] = IOBufCom[i+20];
    }    
    sendIOstatus();
}

void flip() {
    out2 = 0;
    led4 = 0;
    wait_us(1);
    led4 = 1;
    wait_us(2);
    led4 = 0;
    //    pc.printf("o20 ");
    
}    

void sendIOmsg(int iMsg) {
    switch (iMsg) {
    case 48:          //0-READY FOR WELDING
        showTPstatus(16);
        int t = SetLasComm(52);
        flagWeld = 0; 
        sendIOstatus(); 
        break;
    case 49: {showTPstatus(17); flagWeld = 0; sendIOstatus(); break;}    //1-WOBBLE HEAD INIT...
    case 50: {showTPstatus(18); flagWeld = 0; sendIOstatus(); break;}    //2-WOBBLE HEAD ERROR
    case 51: {showTPstatus(19); flagWeld = 0; sendIOstatus(); break;}    //3-IO CONTROLLER ERROR
    case 52: {showTPstatus(20); flagWeld = 1; sendIOstatus(); break;}    //4-WELDING IN PROGRESS..
    case 53:                                                             //5-auto reset e-stop
        showTPstatus(16);
        out2 = 1;
        led4 = 1;
        resetTime.attach(&flip, 0.5); //the address of the function to be attached (flip) to ticker
        //printf("o21 ");
        flagWeld = 0;
        sendIOstatus();
        break;
    case 54:                                                             //6-send laser command
        if(TPstatus == 0) wrIOChar(0x30);   //0000-ready & no err
        else wrIOChar(0x38);                //1000-not ready & no err 
        wrIOChar(0x33); //3-laser STA send
        
        wrIOint(usta);        
        wrIOChar(0xD);          //senr <CR>

        flagWeld = 0;
        break;
    }
}    

void ioCommand(void) {
    if(indIOCom < 2) {
        sendIOerr(06);    //err 06 = Short command
        indIOCom =0;
        return;
    }
    int a = IOBufCom[0];
    int b = IOBufCom[1];
    if (((a == 67) || (a == 99)) && (b == 48)) sendIOstatus();   //C0 or c0
    else if (((a == 67) || (a == 99)) && (b == 49)) sendIOpar();  //C1 or c1
    else if (((a == 67) || (a == 99)) && (b == 50)) sendIOout();  //C2 or c2
    else if (((a == 67) || (a == 99)) && (b == 51)) sendIOinp();  //C3 or c3
    else if ((a == 69) || (a == 101)) sendIOmsg(b);  //E<b> or e<b> command
    else sendIOerr(07);    //err 07 = Wrong command
    indIOCom =0;
}    

//=========================================================

//execute L.command
void LaserCommand(void)  //laser control
{
    if(stL3 == 0) {     // check commands will be execute

        if(stLhmi == 2) {stL3 = stL3 + 1;}  //command from hmi
        if(iPCcmd != 0) {     //command from pc
            stLpc = 2;
            stL3 = stL3 + 2;
        }
        if(stL3 == 0) flagLcomProcess = 0;
        else flagLcomProcess = 1;
    }

    if(stL3 & 1) {   //hmi command
        if(stLhmi == 2) {      //send hmi command to laser
            while(LasRS232.readable()) {
                iLasO = LasRS232.getc();
            }
            iLasO = 0;
            
            for (int i = 0; i < indLhmi; i++) {
                LasRS232.printf("%c", hmiLBuf[i]);
            }
            LasRS232.printf("\r");
            iCounts = 0;
            stLhmi = 3;    
        }
        else if(stLhmi == 3) {      //wait response from laser
            if(LasRS232.readable()) {
lasRS2:
                iLasO = LasRS232.getc();
                LasBufResp[indLResp++] = (char)iLasO;
                if(iLasO == 13) {
                    stLhmi = 4;
                    iCounts = 0;
                    flagLrsConnected = 1;
                }
                if(LasRS232.readable()) goto lasRS2;
            }
            else {        
                ++iCounts;
                if(iCounts > 400) {
                    indStat = 11;       //error 11 - lazer does not answer
                    indLResp = 0;
                    stLhmi = 0;
                    stL3 = stL3 & 0xE;  //no hmi command
                    flagLrsConnected = 0;
               }
            }
        }
        else if(stLhmi == 4) {      //response to hmi 
            //printf("L %c %c\n", *LasBufResp, *hmiLBuf);
            if (*LasBufResp == *hmiLBuf) {
                if (iSta == 1) {    //update L.status to hmi 
                    c = 0;
                    for(int i=6; i<indLResp; i++) {
                        c = (c * 10) + LasBufResp[i-1] - '0';
                    }
                    usta = c;
                    iSta = 0;
                }
                indStat = 0;        //done
                stLhmi = 5;
            }
            else {
                indStat = 12;       //error 12 - laser command error
                stLhmi = 5;
            }
        }               
        else if(stLhmi == 5) {      //delay for next command
            ++iCounts;
            if(iCounts > iCmax) {
                indLResp = 0;
                stL3 = stL3 & 0xE;  //no hmi command
                stLhmi = 0;
            }
        }               
    }
        
    else if(stL3 & 2) {   //pc command       
        if(iPCcmd == 1) {
            if(stLpc == 2) {   //send pc command to laser
                while(LasRS232.readable()) {
                    iLasO2 = LasRS232.getc();
                }
                for (int i = 2; i < (comBufPointer-1); i++) {
                   LasRS232.printf("%c", comBuf[i]);
                   //pc.printf("a%c ", comBuf[i]);
                }    
                LasRS232.printf("\r");
                iCounts = 0;
                stLpc = 3;
            }
            else if(stLpc == 3) {    //wait response from laser
                if(LasRS232.readable()) {
lasRS1:
                    iCh = LasRS232.getc();
                    iCounts = 0;
                    if(iCh == 13) {         //CR - carrier return
                        wrChar('\n');       //send LF to pc
                        wrChar('>');
                        stLpc = 4;
                    }    
                    else {
                        wrChar(char(iCh));
                    }
                    if(LasRS232.readable())    goto lasRS1;
                }        
                else {        
                    ++iCounts;
                    if(iCounts > 400) { //200mS
                        wrCharArr(err101);    //err101 = "No response\n"
                        comBufPointer =0;
                        stL3 = stL3 & 0xD;
                        iPCcmd = 0;
                        stLpc = 0; 
                    }
                }        
            }
            else if(stLpc == 4) {      //delay for next command
                ++iCounts;
                if(iCounts > iCmax) {
                    comBufPointer =0;
                    stL3 = stL3 & 0xD;
                    iPCcmd = 0;
                    stLpc = 0;
                }
            }               
            
        }
        else if(iPCcmd == 2) {

            wrChar('S');
            wrChar('T');
            wrChar('A');
            wrChar(' ');
            wrInt(usta);
            wrChar('\n');
            wrChar('>');
            comBufPointer =0;
            stL3 = stL3 & 0xD;
            iPCcmd = 0;
            stLpc = 0;
            
        }              
        else if(iPCcmd == 3) {

            wrChar('I');
            wrChar(' ');
            wrWord(wBp);
            wrChar(' ');
            wrWord(sBp);
            wrChar(' ');
            //wrChar('\n');
            int a = sBp;
            for(int i=0; i<32; i++) {
                wrChar(pcBuf[a--]);
                if(a<0) {a=pcBufSize-1;}
            }    
            wrChar('\n');
            wrChar('>');
            comBufPointer =0;
            stL3 = stL3 & 0xD;
            iPCcmd = 0;
            stLpc = 0;
            
        }
        else if(iPCcmd == 4) {

            wrChar('L');
            wrChar('A');
            wrChar(' ');
            wrInt(a7);
            wrChar(' ');
            wrInt(b7);
            wrChar(' ');
            wrInt(c7);
            wrChar(' ');
            wrInt(d7);
            wrChar('\n');
            wrChar('>');
            comBufPointer =0;
            stL3 = stL3 & 0xD;
            iPCcmd = 0;
            stLpc = 0;
            a7 = 0; b7 = 0; c7 = 0; d7 = 0;
        }
        else if(iPCcmd == 5) {
/*
            wrInt(indLCabcc);
            wrChar(' ');
            wrChar('L');
            wrChar('C');
            wrChar(' ');
            wrChar('"');
            
            for(int i=0; i<indLCabcc; i++) {
                wrChar(LabccBufCom[i]);        
            }    
*/          a7=0; b7=0, c7=0; d7=0;
            wrChar('5');
            wrChar('\n');
            wrChar('>');
            comBufPointer =0;
            stL3 = stL3 & 0xD;
            iPCcmd = 0;
            stLpc = 0;
            
        }
        else if(iPCcmd == 6) {
            pc.printf("wMode %i\n", prPar[progNumber].wMode); 
            pc.printf("Lmode %i\n", prPar[progNumber].Lmode); 
            pc.printf("LPbeg %i\n", prPar[progNumber].LPbeg); 
            pc.printf("LPend %i\n", prPar[progNumber].LPend); 
            pc.printf("Lfreq %i\n", prPar[progNumber].Lfreq); 
            pc.printf("Lpulse %i\n", prPar[progNumber].Lpulse); 
            pc.printf("amplBeg %i\n", prPar[progNumber].amplBeg); 
            pc.printf("amplEnd %i\n", prPar[progNumber].amplEnd); 
            pc.printf("wFreq %i\n", prPar[progNumber].wFreq); 
            pc.printf("wTime %i\n", prPar[progNumber].wTime); 
            pc.printf("amplNum %i\n", prPar[progNumber].amplNum); 
    
            wrChar('\n');
            wrChar('>');
            comBufPointer =0;
            stL3 = stL3 & 0xD;
            iPCcmd = 0;
            stLpc = 0;
            
        }
    }
}

void flipRS(void) {
    led2 = 1;
    //check io RS232 command
    if(ioRS232.readable()) {
flip01:
        iCh = ioRS232.getc();
        IOBufCom[indIOCom++] = (char)iCh;
        if(iCh == 13) {    //CR - carriage return
            ioCommand();
        }
        if(ioRS232.readable()) goto flip01;
    }
    //check response
    if(ioRS232.writeable()) {
        if(sBio != wBio) {    //ioBuf not empty
            int ff = 12;
flip02:
            ioRS232.putc(IOBufResp[sBio++]);
            if(sBio == IOBufSize) {sBio = 0;}
            --ff;
            if((sBio != wBio) && (ff > 0)) goto flip02;
        }    
    }
    //check pc RS232 command
    if(pc.readable()) {
        iCh = pc.getc();
        comBuf[comBufPointer++] = (char)iCh;
        wrChar(iCh);
        if(iCh == 10) {    //LF - new line
            comParser();
        }    
    }
    
    if(pc.writeable()) {
        if(sBp != wBp) {    //pcBuf not empty
            pc.putc(pcBuf[sBp++]);
            if(sBp == pcBufSize) {sBp = 0;}
        }    
    }
    //serve Laser RS232 command
    LaserCommand();
    led2 = 0;
}

//=========================================================
int lampSt;

void main_cycle_add(void)
{
    if((flagWeld == 0) & (lampSt == 1)) {
        outLampStart = 0;
        lampSt = 0;
    }    
    else if((flagWeld == 1) & (lampSt == 0)) {
        outLampStart = 1;
        lampSt = 1;
    }    
}

