#include "mbed.h"
#include "nRF24L01P.h"
#include "TSISensor.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2,    // MOSI
                       PTD3,    // MISO
                       PTD1,    // SCK
                       PTA13,   // CSN
                       PTD5,    // CE
                       PTD0);   // IRQ
#define TRANSFER_SIZE   4

DigitalOut led(LED_GREEN);

TSISensor tsi;

int main()
{

    pc.baud(115200);
    pc.format();

    char txData[TRANSFER_SIZE];
    int txDataCnt = 4;

    my_nrf24l01p.powerUp();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.enable();

    while (1) {

        while(tsi.readPercentage() < 0.5);
        txData[0] = 's';
        txData[1] = 't';
        txData[2] = 'a';
        txData[3] = '\0';
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("txData: %s \n\r", txData);

        wait(1);

        while(tsi.readPercentage() < 0.5);
        txData[0] = 'S';
        txData[1] = 'T';
        txData[2] = 'A';
        txData[3] = '\0';
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("txData: %s \n\r", txData);

        wait(1);
    }
}

/*
/////////////////////////////////////////////////////////////////////////////////////
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2,    // MOSI
                       PTD3,    // MISO
                       PTD1,    // SCK
                       PTA13,   // CSN
                       PTD5,    // CE
                       PTD0);   // IRQ
#define TRANSFER_SIZE   4

DigitalOut led(LED_GREEN);

int main() {

    pc.baud(9600);
    pc.format();

    char txData[TRANSFER_SIZE];
    txData[0] = 's';
    txData[1] = 't';
    txData[2] = 'a';
    txData[3] = '\0';
    int txDataCnt = 4;

    my_nrf24l01p.powerUp();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.enable();

    while (1)
    {
        led = 1 - led;
        wait(2.0);

        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

        pc.printf("txData: %s \n\r", txData);
    }
}


/////////////////////////////////////////////////////////////////////////////////////
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2,    // MOSI
                       PTD3,    // MISO
                       PTD1,    // SCK
                       PTA13,   // CSN
                       PTD5,    // CE
                       PTD0);   // IRQ
#define TRANSFER_SIZE   4

TSISensor tsi;

DigitalOut led(LED_GREEN);

int main() {

    pc.baud(9600);
    pc.format();

    char txData[TRANSFER_SIZE];
    txData[0] = 's';
    txData[1] = 't';
    txData[2] = 'a';
    txData[3] = '\0';
    int txDataCnt = 4;

    my_nrf24l01p.powerUp();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.enable();

    while(1)
    {
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        //wait(0.5);
        //pc.printf("txData: %s \n\r", txData);
        //led = 1 - led;
    }
}

/////////////////////////////////////////////////////////////////////////////////////
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9);
#define TRANSFER_SIZE   32


//DigitalOut led(LED_GREEN);

int main() {

    pc.baud(115200);
    pc.format();

    char txData[TRANSFER_SIZE];
    txData[0] = 's';
    txData[1] = 't';
    txData[2] = 'a';
    txData[3] = '\0';
    int txDataCnt = 4;

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.enable();

    while (1)
    {

        //while(tsi.readPercentage() < 0.5);
        txData[0] = 's';
        txData[1] = 't';
        txData[2] = 'a';
        txData[3] = '\0';
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("txData: %s \n\r", txData);

        wait(1);
        //while(tsi.readPercentage() < 0.5);
        txData[0] = 'S';
        txData[1] = 'T';
        txData[2] = 'A';
        txData[3] = '\0';
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("txData: %s \n\r", txData);

        wait(1);
    }
}*/