#include "mbed.h"
#include "nRF24L01P.h"
#include "rtos.h"

//*******************************************************************************************************************************

/*Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2,    // MOSI
                       PTD3,    // MISO
                       PTD1,    // SCK
                       PTA13,   // CSN
                       PTD5,    // CE
                       PTD0);   // IRQ

DigitalOut led(LED_RED);

int main() {
    pc.baud(9600);
    pc.format();

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   4

    char rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );


    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();

    my_nrf24l01p.enable();

    //my_nrf24l01p.enableAutoAcknowledge();

    while (1)
    {
        //pc.printf("while(1) \r\n"); z
        while( !my_nrf24l01p.readable() );
        //pc.printf("%d", my_nrf24l01p.readable());
        //if ( my_nrf24l01p.readable() )
        {
            //pc.printf("my_nrf24l01p.readable() \r\n");
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            rxData[rxDataCnt] = '\0';
            pc.printf("rxData: %s \n\r", rxData);
            //for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ )
            //{
            //    pc.putc( rxData[i] );
            //}
            //if(rxDataCnt >= 0 && rxData[0] == 's' && rxData[1] == 't')
            {
                //while(1)
                {
                    led = 1 - led;
                    //wait(0.1);
                }
            }
        }
    }
}*/

//*******************************************************************************************************************************

/*
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2,    // MOSI
                       PTD3,    // MISO
                       PTD1,    // SCK
                       PTA13,   // CSN
                       PTD7,    // CE
                       PTD0);   // IRQ
#define TRANSFER_SIZE   4

DigitalOut led(LED_RED);

int main() {
    pc.baud(9600);
    pc.format();

    char rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();

    my_nrf24l01p.enable();

    led = 0;

    while (1)
    {
        while( !my_nrf24l01p.readable() );
        {
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            rxData[rxDataCnt] = '\0';
            pc.printf("rxData: %s \n\r", rxData);
            if(rxDataCnt ==4 && rxData[0] == 's' && rxData[1] == 't' && rxData[2] == 'a')
            {
                led = 1;
            }
            if(rxDataCnt ==4 && rxData[0] == 'S' && rxData[1] == 'T' && rxData[2] == 'A')
            {
                led = 0;
            }
        }
    }
}
*/
//*******************************************************************************************************************************

/*Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2,    // MOSI
                       PTD3,    // MISO
                       PTE1,    // SCK
                       PTA13,   // CSN
                       PTD7,    // CE
                       PTE0);   // IRQ
#define TRANSFER_SIZE   4

DigitalOut led(LED_RED);
DigitalOut led2(LED_GREEN);

//signals
#define START_THREAD_SIGNAL 0x01

Thread *threadCountReceive;
volatile int rxDataCntPerSec;

Mutex stdio_mutex;

void tCountReceive(void const *args)
{
    //Thread::signal_wait(START_THREAD_SIGNAL);
    static int copy;
    while(true) {
        Thread::wait(1000);
//        copy = rxDataCntPerSec;
        //copy++;
        stdio_mutex.lock();
        //pc.printf("ch per sec: %d   %d\r\n",copy,rxDataCntPerSec);
        pc.printf("ch per sec: %d\r\n",rxDataCntPerSec);
        stdio_mutex.unlock();
        //led2=1-led2;
        rxDataCntPerSec = 0;
    }
}

int main()
{
    pc.baud(9600);
    pc.format();

    char rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    threadCountReceive = new Thread(tCountReceive,NULL,osPriorityNormal);
    //Thread::wait(500);
    //threadCountReceive->signal_set(START_THREAD_SIGNAL);
    
    while (1)
    {
        while( !my_nrf24l01p.readable() ) 
        {
            //Thread::wait(10);
        }

        rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
        rxData[rxDataCnt] = '\0';
        stdio_mutex.lock();
        pc.printf("rxData: %d - %d \n\r", rxDataCntPerSec,rxDataCnt);
        rxDataCntPerSec += rxDataCnt;
        stdio_mutex.unlock();

        //led = 1 - led;

    }
}*/

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9);
#define TRANSFER_SIZE   32

DigitalOut led(LED1);

int main() {
    pc.baud(19200);
    pc.format();

    char rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;

    my_nrf24l01p.powerUp();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();

    my_nrf24l01p.enable();

    led = 0;

    while (1)
    {
        while( !my_nrf24l01p.readable() );
        {
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            rxData[rxDataCnt] = '\0';
            pc.printf("rxData: %s \n\r", rxData);
            if(rxDataCnt ==4 && rxData[0] == 's' && rxData[1] == 't' && rxData[2] == 'a')
            {
                led = 1;
            }
            if(rxDataCnt ==4 && rxData[0] == 'S' && rxData[1] == 'T' && rxData[2] == 'A')
            {
                led = 0;
            }
        }
    }
}