#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "RGBLed.h"
#include "wave_player.h"
#include "SDFileSystem.h"


BusOut myled(LED1,LED2,LED3,LED4);

//DigitalOut myled(LED1);
//uLCD_4DGL uLCD(p28, p27, p30);
uLCD_4DGL uLCD(p9, p10, p6);
//DigitalOut audio (p26);
SDFileSystem sd(p11, p12, p13, p8, "sd");

AnalogOut DACout(p18);
wave_player waver(&DACout);
RawSerial bluemod(p28,p27);

 

RGBLed rgb(p23, p22, p21);


Mutex stdio_mutex;
Mutex lcd_mutex;
Mutex bluetooth_mutex;
int i_globe1 = 0;
int i_globe2 = 0;
const char* sound = "/sd/wavfiles/applause.wav";



void send_data(void const * name) {

    while(1) {
        
        stdio_mutex.lock();
        printf("%s %d", name, i_globe1++);
        stdio_mutex.unlock();
        Thread::wait(500);
    }

 
}

void count_1(void const *args) {

    while(1) {
        
        lcd_mutex.lock();
        uLCD.locate(0,0);
        uLCD.printf("%d", i_globe1++);
        lcd_mutex.unlock();
        Thread::wait(500);
    }

        
        
}

void count_2(void const *args) {

    while(1) {
        
        lcd_mutex.lock();
        uLCD.locate(5,0);
        uLCD.printf("%d",i_globe2++);
        lcd_mutex.unlock();
        Thread::wait(500);
    }

        
}


void play_sound(void const *args) {

    


    while(1) {
        
        FILE* fp = fopen(sound, "r");
        waver.play(fp);
        fclose(fp);
        Thread::wait(1000);

    }
    
}

void control_rgb1(void const *args) {
    
    while(1) {
        stdio_mutex.lock(); 
        rgb.setColor (0, 0.0, 0);    
        stdio_mutex.unlock();
    }
    Thread::wait(1000);
}

void control_rgb2(void const *args) {
    
    while(1) {
        
        //if (on = 0) {
            stdio_mutex.lock() ;
            for (float i = 0; i < 1; i+=.1) {
                rgb.setColor (i, i, 1.0);
                
            }   
            stdio_mutex.unlock();
        }
    //}
    Thread::wait(1000);
}


int main() {
    
    
    
    char bred=0;
    char bgreen=0;
    char bblue=0;
    float red = 0.0f;
    float  green = 0.0f;
    float  blue = 0.0f;
    
     Thread t1 (play_sound);
    //Thread::wait(1000);
    //Thread t2 (send_data, (void *)"th 2");
    //Thread::wait(1000);
    //Thread t3 (send_data, (void *)"th 3");
    
    //Thread t2 (control_rgb1);
    
    //Thread t3 (control_rgb2);

    
    Thread t4 (count_1);
    //Thread::wait(1000);

    
    Thread t5 (count_2);
    char bnum=0;

    while(1) {
        
        
        if (bluemod.getc()=='!') {
            if (bluemod.getc()=='C') { //color data packet
                bred = bluemod.getc(); // RGB color values
                bgreen = bluemod.getc();
                bblue = bluemod.getc();
                if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                    red = bred/255.0; //send new color to RGB LED PWM outputs
                    green = bgreen/255.0;
                    blue = bblue/255.0;
                    
                    bluetooth_mutex.lock();
                    rgb.setColor(1 - green, 1 - blue ,  1 - red);
                    bluetooth_mutex.unlock();
                }
            
            
                
            
            }
            
          if (bluemod.getc()=='B') { //button data
            bnum = bluemod.getc(); //button number
            if ((bnum =='1') && bluemod.getc()){ //is a number button 1..4
                    lcd_mutex.lock();
                    //i_globe1 = 0; //turn on/off that num LED
                    uLCD.color(0xFF);
                    //sound = "/sd/wavfiles/BUZZER.wav";   
                    lcd_mutex.unlock();
            } else if (bnum == '2' && bluemod.getc()) {
                
                lcd_mutex.lock();
                sound = "/sd/wavfiles/BUZZER.wav";   
                lcd_mutex.unlock(); 
            }
        } 

    }
        
        Thread::wait(200);

    }
            
            
            
            
            
        
     
        
    


}

