#include "Sensors.h"
#include "Logging.h"

Sensors::Sensors(SensorsConfig_t p_config)
    : m_sDht(p_config.dht, DHT11),
      m_sMotion(p_config.motion),
      m_sLight(p_config.light),
      m_sSwitch1(p_config.switch1),
      m_sSwitch2(p_config.switch2),
      m_updatePeriod_s(p_config.UpdatePeriod_s),
      m_nextUpdate(time(NULL))
{
    m_switch1 = true;
    m_sSwitch1 = 1;
    m_switch2 = true;
    m_sSwitch2 = 1;

    updateValues();
}

Sensors::~Sensors()
{
}

void Sensors::updateValues()
{
    if (m_nextUpdate > time(NULL)) {
        return; // <==
    }
    
    int err = m_sDht.readData();
    if (err != 0) {
        LOG_DEBUG("Can't read DHT %d", err);
    } else {
        m_temp = m_sDht.ReadTemperature(CELCIUS);
        m_humidity = m_sDht.ReadHumidity();
        LOG_DEBUG("Temperature is %4.2f C", m_temp);
        LOG_DEBUG("Humidity is %4.2f", m_humidity);
    }
    int val;

    val = m_sMotion;
    m_motion = (val != 0);
    LOG_DEBUG("Motion is %s", val != 0 ? "Triggered" : "Idle");

    m_light = m_sLight.read() * 3.3f;
    LOG_DEBUG("Light is %4.2f", m_light);
    
    m_nextUpdate = time(NULL) + m_updatePeriod_s;
}

float Sensors::getTemp()
{
    return m_temp;
}

float Sensors::getHumidity()
{
    return m_humidity;
}

bool Sensors::getMotion()
{
    return m_motion;
}

float Sensors::getLight()
{
    return m_light;
}

bool Sensors::getSwitch1()
{
    return m_switch1;
}

bool Sensors::getSwitch2()
{
    return m_switch2;
}

void Sensors::setSwitch1(bool value)
{
    m_switch1 = value;
    m_sSwitch1 = (value ? 1 : 0);
}

void Sensors::setSwitch2(bool value)
{
    m_switch2 = value;
    m_sSwitch2 = (value ? 1 : 0);
}
