/* Copyright (c) 2015 Vertical M2M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __SENSORS__
#define __SENSORS__

#include "mbed.h"
#include "DHT.h"

#include <string>

struct SensorsConfig_t
{
    PinName dht;
    PinName motion;
    PinName light;
    PinName switch1;
    PinName switch2;
    
    time_t UpdatePeriod_s;
};

class Sensors {
public:
    Sensors(SensorsConfig_t p_config);
    ~Sensors();
    
    void updateValues();
    
    float getTemp();
    float getHumidity();
    bool getMotion();
    float getLight();
    bool getSwitch1();
    bool getSwitch2();
    void setSwitch1(bool value);
    void setSwitch2(bool value);
    
private:
    /**
     * Sensors
     */
    DHT m_sDht;
    DigitalIn m_sMotion;
    AnalogIn m_sLight;
    DigitalOut m_sSwitch1;
    DigitalOut m_sSwitch2;
    
    /**
     * Values
     */
    float m_temp;
    float m_humidity; 
    bool m_motion;
    float m_light;
    bool m_switch1;
    bool m_switch2;
    
    /**
     * Update configuration
     */
    time_t m_updatePeriod_s;
    time_t m_nextUpdate;
};

#endif