/* Copyright (c) 2015 Vertical M2M, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __LORA__
#define __LORA__
#include "mbed.h"
#include "mDot.h"
#include <string>
#include <list>

#define LORA_PACKET_MAX_SIZE 51

struct LoRaConfig_t {
    /**
     * LoRa Network name
     */
    std::string networkName;

    /**
     * LoRa Network key pass
     */
    std::string networkPassphrase;

    /**
     * LoRa Frequence sub band
     */
    uint8_t subBand;

    /**
    * LoRa Spreading factor
    */
    mDot::DataRates spreadingFactor;
   
    /**
     * Delay in second for seending keepalive
     */
    uint16_t loraDelayForKeepAlive;
    
    /**
     * Delay in second between LoRa message
     */
    uint16_t loraMinDelayBetweenMessage;
};

class LoRa
{
public:
    LoRa();
    ~LoRa();

    bool init(LoRaConfig_t p_config);
    bool connect();

    std::string getError();
    std::string getVersion();

    void send(const std::string text);
    std::string receive();

    void PeriodicTimer();

private:
    enum SendResult {
        e_srOK,
        e_srWaitMore,
        e_srError
    };

    bool setupNetwork();

    SendResult _send(const std::string text);
    std::string _receive();

    /**
     * List of string to send
     */
    std::list<std::string> m_toSend;

    /**
     * List of string to getted
     */
    std::list<std::string> m_readed;

    int m_errorCode;
    mDot* m_dot;

    /**
     * LoRa protectoin timer
     */
    time_t m_nextSend;
    time_t m_nextKeepalive;

    /**
     * Current message to send, next time
     */
    std::string m_currentMessage;

    /**
     * Delay in second for seending keepalive
     */
    uint16_t m_delayForKeepAlive;
    
    /**
     * Delay in second between LoRa message
     */
    uint16_t m_minDelayBetweenMessage;
};

#endif