#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"

DigitalOut led(LED1);
LCD_DISCO_F429ZI lcd;
Serial pc(PA_9, PA_10, 9600);
Serial esp(PD_5, PD_6, 115200);

char str[128], temp[32];

int main() 
{
    BSP_LCD_SetFont(&Font16);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.Clear(LCD_COLOR_WHITE);
  
    //Отключаем эхо
    esp.printf("ATE0\r\n");
    wait(0.1);
    
    //Отправляем команду "AT"
    pc.printf("PC: AT\n");
    esp.printf("AT\r\n");
    
    //Слушаем ответ
     do{
        esp.scanf("%s", temp);
        strcat(str, temp);  
    }while(strcmp(temp, "OK") && strcmp(temp, "ERROR"));
    pc.printf("Esp: %s\n", str);
    
    //Отправляем команду "AT+GMR"
    pc.printf("PC: AT+GMR\n");
    esp.printf("AT+GMR\r\n");
    
    //Слушаем ответ
     do{
        esp.scanf("%s", temp);
        strcat(str, temp);  
    }while(strcmp(temp, "OK") && strcmp(temp, "ERROR"));
    pc.printf("Esp: %s\n", str);
    
    
    
    while(1) 
    {
        led = 1;
        wait(1);
        led = 0;
        wait(1);
    }
}

//lcd.DisplayStringAt(0, LINE(1), (uint8_t *)str, LEFT_MODE);