/* Program Example 12.8: Ethernet read with display to onboard lcd
                                                                          */
#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

Ethernet eth;                          // Ethernet object

char buf[0xFF];                        // create a large buffer to store data 
int main() {
  lcd.locate(0,0);
  lcd.printf("Ethernet data read and display\n\r");
  while (1) {
    int size = eth.receive();              // get size of incoming data packet
    if (size > 0) {                        // if packet received
      eth.read(buf, size);                 // read packet to data buffer
      lcd.locate(10,0);
      lcd.printf("size = %d data = ",size); // print to screen
      for (int i=0;i<size;i++) {           // loop for each data byte
        lcd.locate(20,0);
        lcd.printf("%02X ",buf[i]);         // print data to screen
        wait(0.33);
      }
      // pc.printf("\n\r");
    }
  }
}
