/*********************************************************************
  led_fsm      first mbed (lpc1768) program
               Simple finite state machine for 
               mbed's onboard LEDs sequencing

 author: Ivan Vengust 'vitrzin'
 last change: 14. oct. 2010               
*********************************************************************/
#include "mbed.h"

// Function prototypes
int fsm(void);
int fsm1(void);

// Global variables
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// main ************************************************************
int main() 
{
    int c(0), status;
    
    while(1) 
    {
        if (c > 2) // decide which sequence
            status = fsm1(); // call sequence change
        else
            status = fsm();
        
        if (status == 0)
        {
            c = ++c % 5; // count finished sequences
        }
    }
}

/**********************************************************************
  fsm()   Simple finite state machine
           Each call to 'fsm' will advance state machine to next state
          return value: current state 
**********************************************************************/  
int fsm(void) // light each led on turn - 4 states
{
    static int st(0); // sequence state
    const int dly(200); // base delay - 200 ms

    switch(st)
    {
       case 0:            //  state 0
         led4 = 0; // change leds 
         led3 = 0;
         led2 = 0;
         led1 = 1;
         wait_ms(dly*3); // wait longer in initial state
         ++st;     // switch to next state       
         break;
       case 1:            //  state 1 
         led1 = 0;
         led2 = 1;
         ++st;
         break;
       case 2:            //  state 2
         led2 = 0;
         led3 = 1;
         ++st;
         break;
       case 3:            //  state 3
         led3 = 0;
         led4 = 1;
         st=0;    // switch to initial state       
         break;
    }
    wait_ms(dly);
    return st;
}

int fsm1(void) // light led column - 8 states
{
    static int st(0); // sequence state
    const int dly(400); // base delay - 200 ms

    switch(st)
    {
       case 0:            //  state 0
         led4 = 0; // change leds 
         led3 = 0;
         led2 = 0;
         led1 = 0;
         wait_ms(dly*2); // wait longer in initial state
         ++st;     // switch to next state       
         break;
       case 1:            //  state 1 
         led4 = 1;
         ++st;
         break;
       case 2:            //  state 2
         led3 = 1;
         ++st;
         break;
       case 3:            //  state 3
         led2 = 1;
         ++st;
         break;
       case 4:            //  state 4
         led1 = 1;
         ++st;
         break;
       case 5:            //  state 5
         led1 = 0;
         ++st;
         break;
       case 6:            //  state 6
         led2 = 0;
         ++st;
         break;
       case 7:            //  state 7
         led3 = 0;
         ++st;
         break;
       case 8:            //  state 8
         led4 = 0;
         st=0;    // switch to initial state       
         break;
    }
    wait_ms(dly);
    return st;
}