#include "display.h"

/**************************************************************************************************************************
************************** Transform humiditity / temperature float value to string ***************************************
**************************************************************************************************************************/
// If isTemp = 0, string includes
// 1. current humididty
// 3. " %"

// If isTemp = 1, string includes
// 1. "-" (optional),
// 2. current temperature with decimal mark
// 3. " С"
void Display::CreateStringTempHum(char *str, float number, bool isTemp)
{
    short int multipedNumber = (short int)(number * 100);
    char strCnt = 0;
    if (isTemp) {
        if (multipedNumber < 0) {
            multipedNumber = -multipedNumber;
            str[strCnt] = '-';
            strCnt++;
        }
    }
    if (multipedNumber >= 10000) {
        str[strCnt] = '0' + (multipedNumber % 100000) / 10000;
        strCnt++;
    }
    if (multipedNumber >= 1000) {
        str[strCnt] = '0' + (multipedNumber % 10000) / 1000;
        strCnt++;
    }
    if (multipedNumber >= 100) {
        str[strCnt] = '0' + (multipedNumber % 1000) / 100;
        strCnt++;
    }
    if (isTemp) {
        str[strCnt] = '.';
        strCnt++;
        str[strCnt] = '0' + (multipedNumber % 100) / 10;
        strCnt++;
        str[strCnt] = ' ';
        strCnt++;
        str[strCnt] = 'C';
        strCnt++;
    } else {
        str[strCnt] = '%';
        strCnt++;
    }
    str[strCnt] = 0;
}