#include "ad5422_arduino.h"
#include "PGA280.h"
#include <math.h>
#include "PerifConfig.h"
#include <stdbool.h>


void ad5422_resetDevice (  unsigned char adr )
{
    pga280_setAdress ( adr );
    ADS1259_RESET = 0;
    
    wait_ms ( 1 );                            // ??? 1 Mhz 70
    
    ADS1259_RESET = 1;
    pga280_resetAdress ();
}

void ad5422_powerDownDevice ( unsigned char adr )
{
    pga280_setAdress ( adr );
    
    ADS1259_RESET = 0;
    
    pga280_resetAdress ();
}

void ad5422_powerUpDevice ( unsigned char adr )
{
    pga280_setAdress ( adr );
    
    ADS1259_RESET = 1;
    
    pga280_resetAdress ();
}

char ad5422_readyDevice ( unsigned char ch )
{
    char tmp;
    
    pga280_setAdress ( ch );
    
    if ( CRDYA == 0 )
        tmp = true;
    else
        tmp = false;
    
    pga280_resetAdress ();
    
    return tmp;
}

char ad5422_sendCommandDevice ( unsigned char reg, unsigned char high_byte, unsigned char low_byte, unsigned char adr )
{
    pga280_setAdress ( adr );
    
    CS = 0;    
    SPI1MasterTransferByte ( reg );
    SPI1MasterTransferByte( high_byte );
    SPI1MasterTransferByte( low_byte );    
    CS = 1;
    
   pga280_resetAdress ();
    
  return true;
}

uint32_t ad5422_readReg ( unsigned char reg, unsigned char adr )
{    
    union {
    struct {
        uint8_t
        b0,
        b1,
        b2;
    };
    uint32_t data;
    }read;
  
    pga280_setAdress ( adr );
    CS = 0;
  
    SPI1MasterTransferByte( AD5422_READBACK );
    SPI1MasterTransferByte( 0x00 );
    SPI1MasterTransferByte( reg );

    read.b0 = SPI1MasterReadByte();
    read.b1 = SPI1MasterReadByte();
    read.b2 = SPI1MasterReadByte();    
    
    CS = 1;
    pga280_resetAdress ();
    
    return read.data;
}

unsigned int ad5422_setRegisters ( void )
{
    ad5422_sendCommandDevice ( AD5422_REG_RESET, 0x00, 0x01, AD5422_ADR );    
    ad5422_sendCommandDevice ( AD5422_REG_CONTROL, 0x30, 0b00000001, AD5422_ADR );
    return 1;
}

unsigned int ad5422_setRegistersChannal ( char channal )
{
    int i;
    
    for ( i = 0; i < channal; i++ )
        ad5422_sendCommandDevice ( AD5422_REG_RESET, 0x00, 0x01, AD5422_ADR );
    
    wait_ms (1);
    
    for ( i = 0; i < channal; i++ )
        ad5422_sendCommandDevice ( AD5422_REG_CONTROL, 0x00, 0x08, AD5422_ADR );
    
    wait_ms (1);
    
    for ( i = 0; i < channal; i++ )
        ad5422_sendCommandDevice ( AD5422_REG_CONTROL, 0x30, 0x09, AD5422_ADR );
    
    wait_ms (1);
    
    return 1;
}

unsigned char ad5422_setVoltageChannal ( float voltage, char channal )
{    
    unsigned long tmp;
    float v_ref = 5.2;
    unsigned char gain = 2;
    unsigned int value_output;
    unsigned char value_output_high;
    unsigned char value_output_low;
    int i;
    
    tmp = ( voltage / ( v_ref * gain ) ) * 0xFFFF; 
    value_output = ( v_ref * gain ) - tmp;
    value_output_high = ( value_output >> 8 ) * 0xFF;
    value_output_low = value_output * 0xFF;
    
    for ( i = 0; i < channal; i++ )
        ad5422_sendCommandDevice ( AD5422_REG_DATA, value_output_high, value_output_low, AD5422_ADR );
    
    return (0);
}
