#ifndef _AD5422_ARDUINO_H    /* Guard against multiple inclusion */
#define _AD5422_ARDUINO_H
#include <stdint.h>
/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

#define AD5422_ADR                           0
////////////////////////////////////////////// 
// ************ Commands AD5422 *********** //
//////////////////////////////////////////////
    
#define AD5422_NOP                        0x00
#define AD5422_REG_DATA                   0x01
#define AD5422_READBACK                   0x02
#define AD5422_REG_CONTROL                0x55
#define AD5422_REG_RESET                  0x56

//////////////////////////////////////////////
// *********** READ Registers ****************** //
//////////////////////////////////////////////

#define AD5422_STATUS_REGISTER            0x00
#define AD5422_DATA_REGISTER              0x01
#define AD5422_CONTROL_REGISTER           0x10

    typedef union{
        struct{
            uint16_t
            R0:1,
            R1:1,
            R2:1,
            DCEN:1,
            SREN:1,
            SRSTEP:3,
            SRCLOCK:4,
            OUTEN:1,
            REXT:1,
            OVRRNG:1,
            CLRSEL:1;            
        };        
        struct{
            uint16_t 
            L:8,
            H:8;            
        };
    }AD5422_CONTROL_t;
    extern AD5422_CONTROL_t AD5422_CONTROL;
    
    typedef union{
        struct{
            uint16_t
            OverTemp:1,
            SlewActive:1,
            IoutFault:1,
            :13;
        };     
        uint16_t w:16;
        
    }AD5422_STATUS_t;
    extern AD5422_STATUS_t AD5422_STATUS;
    
    void ad5422_init ( void );
    void ad5422_resetDevice (  unsigned char adr );
    void ad5422_powerDownDevice ( unsigned char adr );
    void ad5422_powerUpDevice ( unsigned char adr );
    char ad5422_readyDevice ( unsigned char ch );
    char ad5422_sendCommandDevice ( unsigned char reg, unsigned char high_byte, unsigned char low_byte, unsigned char adr );
    uint32_t ad5422_readReg ( unsigned char reg, unsigned char adr );
    unsigned int ad5422_setRegisters ( void );
    unsigned int ad5422_setRegistersChannal ( char channal );
    unsigned char ad5422_setVoltageChannal ( float voltage, char channal );

    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _EXAMPLE_FILE_NAME_H */

/* *****************************************************************************
 End of File
 */
