#include "ADS1259.h"
#include "PGA280.h"
#include "PGA280ADS1259.h"
#include <math.h>


//#include "app.h"
//counter; //сделать переменную видимой в этом файле
void pga280_ads1259_init ( unsigned char ch ) 
{    
    pga280_resetDevice ( ch );
    //ads1259_resetDevice ( ch ); //микросхема снова уходит в сброс как только сменится адрес, так как ножка RESET оключается
    /*Сюда вставить задержку не менее 20 мс (для того чтобы микросхема АЦП раскачалась)*/
    pga280_ads1259_setup_pga280(ch);
    wait_ms(100);    /*задержка перед настройкой АЦП*/
    pga280_ads1259_setup_ads1259(ch);
}

void pga280_ads1259_setup_pga280 ( unsigned char ch )
/*Предварительная настройка PGA280 (Это инициализация по идее)*/

{
    //PGA280_INPUT_SWITCH0.SW_A1=1;
    //PGA280_INPUT_SWITCH0.SW_A2=1;
    pga280_writeOneRegisterDevice ( PGA280_INPUT_SWITCH0_ADR, 0x18, ch ); //выбрать для работы INP2 INN2   
    pga280_writeOneRegisterDevice ( PGA280_INPUT_SWITCH1_ADR, 0, ch );    
    pga280_writeOneRegisterDevice ( PGA280_GPIO_DIR_ADR, 0b111111, ch );   //установить первые 6 выводов на выход
    pga280_writeOneRegisterDevice ( PGA280_CS_MODE_ADR, 0b00010000, ch );    //ECS4 в расширенном CS режиме
    pga280_writeOneRegisterDevice ( PGA280_SP_FUNCTION_ADR,7 , ch );//выводы GPIO0-2 используются для функции MUX
}

void pga280_ads1259_setup_ads1259 ( unsigned char ch )
/*Настройка АЦП*/
{
    pga280_directCsBegin ( 4, ch );
    ads1259_resetDevice(ch);                                        //костыльная функция
    wait_ms(20);                                                    //пауза для выхода на режим работы
    ads1259_sendCommandDevice ( SDATAC_ADS1259 );                   //установить чтение в постоянном режиме
    ads1259_writeOneRegisterDevice ( CONFIG0_ADS1259, 0x04 );       //0x04
    ads1259_writeOneRegisterDevice ( CONFIG1_ADS1259, 0x50 );       //0x50
    ads1259_writeOneRegisterDevice ( CONFIG2_ADS1259, 0x05 );       //0x03  400 400 сэмплов
    /*Настройка смещения так чтобы 7FFFFF - это нулевой уровень*/
    ads1259_writeOneRegisterDevice ( OFC0_ADS1259, 0x68 );//5D
    ads1259_writeOneRegisterDevice ( OFC1_ADS1259, 0x01 );//01
    ads1259_writeOneRegisterDevice ( OFC2_ADS1259, 0x00);   
    /*Конец*/
    /*Настройка масштабирования 1 к 1*/
    ads1259_writeOneRegisterDevice ( FSC0_ADS1259, 0x00 );    
    ads1259_writeOneRegisterDevice ( FSC1_ADS1259, 0x00 );    
    ads1259_writeOneRegisterDevice ( FSC2_ADS1259, 0x40 );//0x40
    /*Конец*/
    pga280_directCsEnd ();
}

unsigned char test_read_reg_ads1259 ( unsigned char ch )
{   
    unsigned char out_data;
    
    pga280_directCsBegin ( 4, ch );    
    out_data = ads1259_readOneRegisterDevice ( CONFIG0_ADS1259 );    
    pga280_directCsEnd ();
    
    return out_data;
}

long ads1259_readData ( unsigned char ch )
/*Эта функция работает, надо пофиксить основную*/
{
    long data_out;
    unsigned char data[4];
    unsigned char data_ok;    
    pga280_directCsBegin ( 4, ch );
    ads1259_sendCommandDevice ( SDATAC_ADS1259 );                               // ?????????? ????? ?????? ?????? ? ?????????? ??????
    pga280_directCsEnd ();
  
    ads1259_conversionON ( ch );                                                // ???????? ???
                                                                                //
    pga280_directCsBegin (4, ch );
    ads1259_sendCommandDevice ( RDATA_ADS1259 );                                // ?????????? ??????? ??????? ???????? ?????? ? ?????????? ??????
    pga280_directCsEnd ();

    do {
        if ( ads1259_readyDevice ( ch ) == true ) {

            
            pga280_directCsBegin ( 4, ch );

            data[0] = SPI1MasterReadByte ();
            data[1] = SPI1MasterReadByte ();
            data[2] = SPI1MasterReadByte ();
            data[3] = 0;

            pga280_directCsEnd ();

            data_ok = true;
            break;
      
        } else {
            data_ok = false;            
        }        
    } while ( 1 );

    data_out = 0;

    if ( data_ok ) {
        data_out += (data[0] & 0xFF) << 24;
        data_out += (data[1] & 0xFF) << 16;
        data_out += (data[2] & 0xFF) << 8;
        data_out += (data[3] & 0xFF);
    } else {
        data_out = 0xFFFFFFFF;
    }

    ads1259_conversionOFF ( ch );                                               // 
    
    return data_out>>8;
}

/* *****************************************************************************
 End of File
 */
