#include "PGA280.h"
#include <math.h>

/*Повторное объявление структур, из-за матюгов линковщика*/
__PGA280_GPIO_t PGA280_GPIO;
__PGA280_MUX_GAIN_t PGA280_MUX_GAIN;
__PGA280_SPI_MODE_t PGA280_SPI_MODE;
__PGA280_BUF_TIMEOUT_t PGA280_BUF_TIMEOUT;
__PGA280_ERROR_t PGA280_ERROR;
adress_t adress;

void pga280_setAdress ( unsigned char adr )
/*Установить адрес микросемы на плате ТЭД-2 для работы*/
{
    adress.adr=adr;
    ADR0 = adress.adr0;
    ADR1 = adress.adr1;
    ADR2 = adress.adr2;
}

void pga280_resetAdress ( void )
/*Сбросить адрес микросхемы на плате ТЭД-2*/
{
    ADR0 = 0;
    ADR1 = 0;
    ADR2 = 0;
}

char pga280_sendCommandDevice ( unsigned char command, unsigned char adr )
/*Отправить устройству по адресу "adr" команду*/
{
    pga280_setAdress ( adr );
    CS = 0;
    SPI1MasterTransferByte(command);
    CS = 1;
    //pga280_resetAdress ();

    return 0xff;
}

unsigned char pga280_readOneRegisterDevice ( unsigned char reg, unsigned char adr)
/*Прочитать регистр "reg" с устройства по адресу "adr"
Функция возвращает значение регистра*/
{
    unsigned char out_value = 0;

    pga280_setAdress ( adr );

    CS = 0;
    SPI1MasterTransferByte ( READ_PGA280 | reg );
    out_value = SPI1MasterTransferByte(0x00 );
    CS = 1;
    //pga280_resetAdress ();

    return out_value;
}

void pga280_writeOneRegisterDevice (unsigned char reg, uint8_t data, unsigned char adr)
/*Записать в регистр "reg" данные "data" в устройство по адресу "adr"*/
{
    pga280_setAdress ( adr );

    CS = 0;
    SPI1MasterTransferByte ( WRITE_PGA280 | reg );
    SPI1MasterTransferByte ( data );
    CS = 1;

    //pga280_resetAdress ();
}

void pga280_writeBufOneRegisterDevice (unsigned char reg, unsigned char data, unsigned char adr)
{
    pga280_setAdress ( adr );
    CS = 0;

    SPI1MasterTransferByte ( WRITE_BUF_PGA280 | reg );
    SPI1MasterTransferByte ( data );

    CS = 1;
    //pga280_resetAdress ();
}

void pga280_directCS ( unsigned char ex_cs, unsigned char adr )
{
    pga280_setAdress ( adr );
    CS = 0;

    SPI1MasterTransferByte ( CS_DIRECT_PGA280 | ex_cs );

    CS = 1;
    //pga280_resetAdress ();
}

void pga280_resetDevice ( unsigned char adr )
{
    pga280_writeOneRegisterDevice ( PGA280_RESET_ADR, 1, adr );
}

void pga280_setMUX ( unsigned char mux, unsigned char adr )
/*Выбрать канал АЦП "mux" на микросхеме по адресу "adr"*/
{
    PGA280_MUX_GAIN.MUX=mux;
    pga280_writeOneRegisterDevice ( PGA280_MUX_GAIN_ADR, PGA280_MUX_GAIN.w, adr );
}

void pga280_setGAIN ( unsigned char gain, unsigned char adr )
/*Установить коэффициент усиления "gain" на устройстве (pga280)
 по адресу "adr" (коэффициенты написаны в заголовочном файле) */
{
    PGA280_MUX_GAIN.GAIN=gain;
    pga280_writeOneRegisterDevice ( PGA280_MUX_GAIN_ADR, PGA280_MUX_GAIN.w, adr );    //запись в адрес регистра содержимого регистра
}

void pga280_directCsBegin ( unsigned char exCS, unsigned char adr )
{
    pga280_setAdress ( adr );

    CS = 0;

    SPI1MasterTransferByte ( CS_DIRECT_PGA280 | exCS );
}

void pga280_directCsEnd ( void )
{
    CS = 1;
    //RESET=0;
    //pga280_resetAdress ();
}

void pga280_setGPIO ( unsigned char num, unsigned char adr )
/*Установить в лог. 1 GPIO вывод с номером "num" на устройстве по адресу "adr"*/
{
    PGA280_GPIO.GPIO |= 1 << num;
    pga280_writeOneRegisterDevice ( PGA280_GPIO_DATA_ADR, PGA280_GPIO.w, adr );
}

void pga280_resetGPIO ( unsigned char num, unsigned char adr )
/*Сбросить в лог. 0 GPIO вывод с номером "num" на устройстве по адресу "adr"*/
{
    PGA280_GPIO.GPIO &= ~(1 << num);
    pga280_writeOneRegisterDevice ( PGA280_GPIO_DATA_ADR, PGA280_GPIO.w, adr );
}