#include "ADS1259.h"
#include "PGA280.h"
#include <math.h>


void ads1259_resetDevice ( unsigned char adr )
{
    RESET = 1;
}

void ads1259_powerDownDevice ( unsigned char adr )
{
    pga280_setAdress ( adr );
    ADS1259_RESET = 0;
    //pga280_resetAdress ();
}

void ads1259_powerUpDevice ( unsigned char adr )
{
    pga280_setAdress ( adr );
    ADS1259_RESET = 1;
    //pga280_resetAdress ();
}

void ads1259_conversionON ( unsigned char ch )
{
    pga280_setGPIO ( 5, ch );
}

void ads1259_conversionOFF ( unsigned char ch )
{
    pga280_resetGPIO ( 5, ch);
}

char ads1259_readyDevice ( unsigned char ch  )
/*Плохая функция проверки готовности устройства.
Необходимо сделать прерывание, которое будт выставлять
флаг или в котором будет происходить считывание*/
{
    char tmp;

    pga280_setAdress ( ch );

    if ( ADS1259_RDYA == 0 )
        tmp = true;
    else
        tmp = false;

    //pga280_resetAdress ();

    return tmp;
}

unsigned char ads1259_sendCommandDevice ( unsigned char command )
{
    //ADS1259_CS = 0;
    SPI1MasterTransferByte ( command );
    //ADS1259_CS = 1;
    return true;
}

void ads1259_setCsAndReset ( void )
{
    //ADS1259_CS = 0;
    wait_ms ( 100 );
    //ADS1259_CS = 1;
    wait_ms ( 100 );
}

unsigned long ads1259_readRegisterDevice ( unsigned char reg, unsigned char num_reg, unsigned char ch )
/*Чтение количества регистров num_reg, начиная с текущего reg по адресу устройства ch*/
{
    unsigned long out_value = 0;

    uint32_t tmp[num_reg];
    unsigned char i;

    if ( num_reg > 3 )
        num_reg = 3;

    pga280_setGPIO ( 5, ch );
    //ADS1259_CS = 0;
    SPI1MasterTransferByte ( RREG_ADS1259 | reg );
    SPI1MasterTransferByte ( num_reg - 1 );

    for ( i = 0; i < num_reg; i++ ) {
        tmp[i] = SPI1MasterTransferByte ( 0x00 );
    }

    //ADS1259_CS = 1;
    pga280_resetGPIO ( 5, ch );

    switch ( num_reg ) {
        case 1:

            out_value = tmp[0];
            break;

        case 2:

            out_value = (tmp[0] << 8) | tmp[1];
            break;

        case 3:

            out_value = ((tmp[0] << 16) | tmp[1] << 8) | tmp[2];
            break;

        default:

            out_value = 0xFFFFFFFF;
            break;
    }

    return out_value;
}

unsigned char ads1259_readOneRegisterDevice ( unsigned char reg )
{
    unsigned char out_value = 0;
    //ADS1259_CS = 0;

    SPI1MasterTransferByte ( RREG_ADS1259 | reg );
    SPI1MasterTransferByte ( 0 );
    out_value = SPI1MasterReadByte ();

    //ADS1259_CS = 1;

    return out_value;
}

void ads1259_writeOneRegisterDevice ( unsigned char reg, unsigned char data )
{
    //ADS1259_CS = 0;

    SPI1MasterTransferByte ( WREG_ADS1259 | reg );
    SPI1MasterTransferByte ( 0 );
    SPI1MasterTransferByte ( data );

    //ADS1259_CS = 1;
}

void ads1259_runReadDataContinuedModeDevice ( unsigned char ch )
{
    ads1259_sendCommandDevice ( SDATAC_ADS1259 );               // ?????????? ????? ?????? ?????? ? ?????????? ??????
    ads1259_conversionON ( ch );                                // ???????? ???
    ads1259_sendCommandDevice ( RDATAC_ADS1259 );               // ?????????? ??????? ??????? ???????? ?????? ? ?????????? ??????
}

uint32_t ads1259_readDataDevice ( unsigned char ch )
{
    uint32_t t_begin;                                           // ????? ??????
    uint32_t t_end;                                             // ????? ?????
    uint32_t t_current;                                         // ??????? ????????
    uint32_t data_out = 0;                                      // ???????? ??????

    unsigned char data_ok;                                      // ?????? ???????

    uint32_t data[4];

    ads1259_sendCommandDevice ( SDATAC_ADS1259 );               // ?????????? ????? ?????? ?????? ? ?????????? ??????
    ads1259_conversionON ( ch );                                // ???????? ???
    ads1259_sendCommandDevice ( RDATA_ADS1259 );                // ?????????? ??????? ??????? ???????? ?????? ? ?????????? ??????

    t_begin = 0;

    do {
        if ( ads1259_readyDevice ( ch ) == true ) {

            //ADS1259_CS = 0;

            data[0] = SPI1MasterReadByte ();
            data[1] = SPI1MasterReadByte ();
            data[2] = SPI1MasterReadByte ();

            //ADS1259_CS = 1;

            data_ok = true;
            break;

        } else {
            data_ok = false;
        }

        t_end++;
        t_current = t_end - t_begin;

    } while ( t_current < TIMEOUT );

    if ( data_ok ) {
        data_out += (data[0] & 0xFF) << 16;
        data_out += (data[1] & 0xFF) << 8;
        data_out += (data[2] & 0xFF);
    } else {
        data_out = 0xFFFFFF;
    }

    ads1259_conversionOFF ( ch );                                 // ????????? ???

    return data_out;
}

/* *****************************************************************************
 End of File
 */
