#ifndef _PGA280_ARDUINO_H    /* Guard against multiple inclusion */
#define _PGA280_ARDUINO_H
#include <stdint.h>
#include "PerifConfig.h"
//#include <stdbool.h>
//#include <stddef.h>
//#include <stdlib.h>

/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

// commands
#define WRITE_BUF_PGA280      0x60
#define WRITE_PGA280          0x40
#define READ_PGA280           0x80
#define CS_DIRECT_BUF_PGA280  0xE0
#define CS_DIRECT_PGA280      0xC0

// registers адреса регистров
#define PGA280_MUX_GAIN_ADR       0x00
#define PGA280_RESET_ADR          0x01
#define PGA280_SPI_MODE_ADR       0x02
#define PGA280_BUF_TIMEOUT_ADR    0x03
#define PGA280_ERROR_ADR          0x04
#define PGA280_GPIO_DATA_ADR      0x05
#define PGA280_INPUT_SWITCH0_ADR  0x06
#define PGA280_INPUT_SWITCH1_ADR  0x07
#define PGA280_GPIO_DIR_ADR       0x08
#define PGA280_CS_MODE_ADR        0x09
#define PGA280_CONFIG0_ADR        0x0A
#define PGA280_CONFIG1_ADR        0x0B
#define PGA280_SP_FUNCTION_ADR    0x0C

// Gain
#define GAIN_1_8_PGA280       0x00       
#define GAIN_1_4_PGA280       0x01
#define GAIN_1_2_PGA280       0x02
#define GAIN_1_PGA280         0x03
#define GAIN_2_PGA280         0x04
#define GAIN_4_PGA280         0x05
#define GAIN_8_PGA280         0x06
#define GAIN_16_PGA280        0x07
#define GAIN_32_PGA280        0x08
#define GAIN_64_PGA280        0x09
#define GAIN_128_PGA280       0x0A

namespace pga280{};
using namespace pga280;

/*Удобное обращение к регистрам если не требуется высокая скорость*/

//Register 0 - Gain and Optional MUX Register (название из даташита)
typedef union {
    struct {
        uint8_t
         MUX0:1,
         MUX1:1,
         MUX2:1,
         G0:1,
         G1:1,
         G2:1,
         G3:1,
         G4:1;
    };
    struct {
        uint8_t MUX:3;
        uint8_t GAIN:4;
        uint8_t :1;
    };    
    uint8_t w;
    
}__PGA280_MUX_GAIN_t;                          //это объявление типа.
extern __PGA280_MUX_GAIN_t PGA280_MUX_GAIN;            //объявление переменной

//Register 2 - SPI: MODE Selection to GPIO-Pin (название из даташита)
typedef union {
    struct {
        uint8_t
         CP0:1,
         CP1:1,
         CP2:1,
         CP3:1,
         CP4:1,
         CP5:1,
         CP6:1,
         :1;
    };
    struct {
        uint8_t CP:7;
        uint8_t :1;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_SPI_MODE_t;                          //это объявление типа.
extern __PGA280_SPI_MODE_t PGA280_SPI_MODE;            //объявление переменной

//Register 3 - BUF Timeout Register (название из даташита)
typedef union {
    struct {
        uint8_t
         BUFTIM0:1,
         BUFTIM1:1,
         BUFTIM2:1,
         BUFTIM3:1,
         BUFTIM4:1,
         BUFTIM5:1,
         :2;
    };
    struct {
        uint8_t BUFTIM:6;
        uint8_t :2;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_BUF_TIMEOUT_t;                          //это объявление типа.
extern __PGA280_BUF_TIMEOUT_t PGA280_BUF_TIMEOUT;            //объявление переменной

//Register 4 -  Error Register (название из даташита)
typedef union {
    struct {
        uint8_t
         IOVerr:1,                          //Input Overvoltage
         GAINerr:1,                         //Gain Network Overload
         OUTerr:1,                          //Output Stage Error (allow approximately 6µs activation delay).
         EF:1,                              //Error Flag. Logic OR combination of error bits of Register 10. This bit can be connected to GPIO3 pin if the bit is configured for output (Register 8) and as a special function (Register 12).
         ICAerr:1,                          //Input Clamp Active
         BUFA:1,                            // Buffer Active
         IARerr:1,                          //Input Amplifier Saturation
         CHKerr:1;                          //Checksum error in SPI. This bit is only active if checksum is enabled.
                                            //This bit is set to 1 when the checksum byte is incorrect.
    };    
    struct {
        uint8_t ERR:8;
    };
}__PGA280_ERROR_t;                          //это объявление типа.
extern __PGA280_ERROR_t PGA280_ERROR;            //объявление переменной

//Register 5 -  GPIO Register (название из даташита)
typedef union {
    struct {
        uint8_t
         GPIO0:1,
         GPIO1:1,
         GPIO2:1,
         GPIO3:1,
         GPIO4:1,
         GPIO5:1,
         GPIO6:1,
         :1;
    };
    struct {
        uint8_t GPIO:7;
        uint8_t :1;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_GPIO_t;                       //это объявление типа.
extern __PGA280_GPIO_t PGA280_GPIO;            //объявление переменной

//Register 6 -  Input Switch Control Register 1 (название из даташита)
typedef union {
    struct {
        uint8_t
         SW_D12:1,
         SW_C2:1,
         SW_C1:1,
         SW_B2:1,
         SW_B1:1,
         SW_A2:1,
         SW_A1:1,
         :1;
    };
    struct {
        uint8_t SWCR0:7;
        uint8_t :1;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_INPUT_SWITCH0_t;                       //это объявление типа.
extern __PGA280_INPUT_SWITCH0_t PGA280_INPUT_SWITCH0;            //объявление переменной

//Register 7 -  Input Switch Control Register 2 (название из даташита)
typedef union {
    struct {
        uint8_t
         SW_G2:1,
         SW_G1:1,
         SW_F2:1,
         SW_F1:1,
         :4;
    };
    struct {
        uint8_t SWCR1:4;
        uint8_t :4;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_INPUT_SWITCH1_t;                       //это объявление типа.
extern __PGA280_INPUT_SWITCH1_t PGA280_INPUT_SWITCH1;            //объявление переменной

//Register 8 -  GPIO Configuration Register (название из даташита)
typedef union {
    struct {
        uint8_t
         DIR0:1,
         DIR1:1,
         DIR2:1,
         DIR3:1,
         DIR4:1,
         DIR5:1,
         DIR6:1,
         :1;
    };
    struct {
        uint8_t DIR:7;
        uint8_t :1;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_GPIO_DIR_t;                       //это объявление типа.
extern __PGA280_GPIO_DIR_t PGA280_GPIO_DIR;        //объявление переменной

//Register 9 -  CS Configuration Mode Register (название из даташита)
typedef union {
    struct {
        uint8_t
         ECS0:1,
         ECS1:1,
         ECS2:1,
         ECS3:1,
         ECS4:1,
         ECS5:1,
         ECS6:1,
         :1;
    };
    struct {
        uint8_t ECS:7;
        uint8_t :1;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_CS_MODE_t;                       //это объявление типа.
extern __PGA280_CS_MODE_t PGA280_CS_MODE;        //объявление переменной

//Register 10 -  Configuration Register 1 (название из даташита)
typedef union {
    struct {
        uint8_t
         IOVerr:1,                          //Input Overvoltage
         GAINerr:1,                         //Gain Network Overload
         OUTerr:1,                          //Output Stage Error (allow approximately 6µs activation delay).
         EDBUFA:1,                         
         ICAerr:1,                          //Input Clamp Active
         BUFAPOL:1,                        
         IARerr:1,                          //Input Amplifier Saturation
         MUX_D:1;                     
    };    
    struct {
        uint8_t CFG0:8;
    };
}__PGA280_CONFIG0_t;                          //это объявление типа.
extern __PGA280_CONFIG0_t PGA280_CONFIG0;            //объявление переменной

//Register 11 -  Configuration Register 1 (название из даташита)
typedef union {
    struct {
        uint8_t
         CHKsumE:1,
         :1,       
         FLGTIM0:1,                         
         FLGTIM1:1,                         
         FLGTIM2:1,                         
         FLGTIM3:1,                   
         :1,                          
         LTD:1;                          
                                           
    };
    struct {
        uint8_t
        :2,
        FLGTIM:4,
        :2;
    };
    struct {
        uint8_t CFG1:8;
    };
}__PGA280_CONFIG1_t;                          //это объявление типа.
extern __PGA280_CONFIG1_t PGA280_CONFIG1;            //объявление переменной

//Register 12 - Special Functions Register (название из даташита)
typedef union {
    struct {
        uint8_t
        /*If the GPIO pins are configured as outputs and these bits are set to 1, the GPIO pins are
        *controlled from Register 0 (if MUX-D = 0).*/
        MUX0:1,
        MUX1:1,
        MUX2:1,
        
        /*A logic OR combination of error bits; see Register 10. This flag can control GPIO3 if this pin is
        *configured as an output and EFout = 1.*/
        EFout:1,
        
        /*The current buffer can be triggered externally by pin GPIO4, if configured as an input. The low-to-
        *high edge of a pulse starts the buffer with a delay of three to four clock cycles. If held high, the buffer [BUFA]
        *remains active. The active time is extended by a minimum of three to four clock cycles plus the time set with FLAGTIM.*/
        BUFTin:1,
        
        /*Pin GPIO5 indicates a buffer active condition (if configured as an output). The BUFA output signal
        * is active high by default, but can be inverted to active low by BUFA Pol.*/
        BUFAout:1,
        
        //External connection for external oscillator input to pin GPIO6 (GPIO6 configured as an input).
        SYNCin:1,                      
        
        //Internal oscillator connected to pin GPIO6 for output (GPIO6 configured as an output).
        OSCout:1;
    };
    struct {
        uint8_t MUX:3;
        uint8_t :5;
    };
    struct {
        uint8_t w:8;
    };
}__PGA280_SP_FUNCTION_t;                          //это объявление типа.
extern __PGA280_SP_FUNCTION_t PGA280_SP_FUNCTION;        //объявление переменной

void pga280_setAdress ( unsigned char adr );
void pga280_resetAdress ( void );
char pga280_sendCommandDevice ( unsigned char command, unsigned char adr );
unsigned char pga280_readOneRegisterDevice ( unsigned char reg, unsigned char adr );
void pga280_writeOneRegisterDevice ( unsigned char reg, unsigned char data, unsigned char adr );
void pga280_writeBufOneRegisterDevice ( unsigned char reg, unsigned char data, unsigned char adr );
void pga280_directCS ( unsigned char ex_cs, unsigned char adr );
void pga280_resetDevice ( unsigned char adr );
void pga280_setMUX (unsigned char mux, unsigned char adr );
void pga280_setGAIN ( unsigned char gain, unsigned char adr );
void pga280_directCsBegin ( unsigned char exCS, unsigned char adr );
void pga280_directCsEnd ( void );
void pga280_setGPIO ( unsigned char num, unsigned char adr );
void pga280_resetGPIO ( unsigned char num, unsigned char adr );

    
    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _EXAMPLE_FILE_NAME_H */

/* *****************************************************************************
 End of File
 */
